/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference.common;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyFixes;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.struts2.reference.common.BeanPropertyPathReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanPropertyPathReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider,
LocalQuickFixProvider {
    private final BeanPropertyPathReferenceSet referenceSet;
    private final int index;

    BeanPropertyPathReference(BeanPropertyPathReferenceSet referenceSet, TextRange range, int index) {
        super(referenceSet.getElement(), range, referenceSet.isSoft());
        this.referenceSet = referenceSet;
        this.index = index;
    }

    private boolean isLast() {
        return this.referenceSet.getReferences().size() - 1 == this.index;
    }

    public PsiMethod resolve() {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            return null;
        }
        return this.resolveProperty(psiClass, this.getValue());
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/common/BeanPropertyPathReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Map properties = PropertyUtil.getAllProperties((PsiClass)psiClass, (boolean)true, (!this.isLast() || this.referenceSet.isSupportsReadOnlyProperties() ? 1 : 0) != 0);
        Object[] variants = new Object[properties.size()];
        int i = 0;
        for (Map.Entry entry : properties.entrySet()) {
            String propertyName = (String)entry.getKey();
            PsiMethod psiMethod = (PsiMethod)entry.getValue();
            PsiType propertyType = PropertyUtil.getPropertyType((PsiMember)psiMethod);
            assert (propertyType != null);
            LookupElementBuilder variant = LookupElementBuilder.create((Object)psiMethod, (String)propertyName).withIcon(psiMethod.getIcon(0)).withStrikeoutness(psiMethod.isDeprecated()).withTypeText(propertyType.getPresentableText());
            variants[i++] = variant;
        }
        if (variants == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/common/BeanPropertyPathReference", "getVariants"));
        }
        return variants;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = "Cannot resolve property '" + this.getValue() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/common/BeanPropertyPathReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name = PropertyUtil.getPropertyName((String)newElementName);
        return super.handleElementRename(name == null ? newElementName : name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String propertyName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/reference/common/BeanPropertyPathReference", "bindToElement"));
        }
        if (element instanceof PsiMethod && (propertyName = PropertyUtil.getPropertyName((PsiMember)((PsiMember)element))) != null) {
            return super.handleElementRename(propertyName);
        }
        return this.getElement();
    }

    public LocalQuickFix[] getQuickFixes() {
        String value = this.getValue();
        if (StringUtil.isEmpty((String)value)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return CreateBeanPropertyFixes.createFixes((String)value, (PsiClass)psiClass, null, (boolean)true);
    }

    @Nullable
    private PsiMethod resolveProperty(@NotNull PsiClass psiClass, String propertyName) {
        PsiMethod method;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/struts2/reference/common/BeanPropertyPathReference", "resolveProperty"));
        }
        PsiMethod psiMethod = method = this.isLast() ? PropertyUtil.findPropertySetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true) : PropertyUtil.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true);
        if (method == null && this.referenceSet.isSupportsReadOnlyProperties()) {
            method = PropertyUtil.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true);
        }
        return method == null || !method.hasModifierProperty("public") ? null : method;
    }

    @Nullable
    private PsiClass getPsiClass() {
        PsiType type;
        if (this.index == 0) {
            return this.referenceSet.getBeanClass();
        }
        PsiMethod method = ((BeanPropertyPathReference)this.referenceSet.getReference(this.index - 1)).resolve();
        if (method != null && (type = method.getReturnType()) instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        return null;
    }
}

