/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditSourceUtil {
    private EditSourceUtil() {
    }

    @Nullable
    public static Navigatable getDescriptor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/EditSourceUtil", "getDescriptor"));
        }
        PsiElement original = EditSourceUtil.getNavigatableOriginalElement(element);
        if (original != null) {
            element = original;
        } else if (!EditSourceUtil.canNavigate(element)) {
            return null;
        }
        if (element instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)element).getTarget();
        }
        PsiElement navigationElement = element.getNavigationElement();
        if (navigationElement instanceof PomTargetPsiElement) {
            return ((PomTargetPsiElement)navigationElement).getTarget();
        }
        int offset = navigationElement instanceof PsiFile ? -1 : navigationElement.getTextOffset();
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(navigationElement);
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return null;
        }
        OpenFileDescriptor desc = new OpenFileDescriptor(navigationElement.getProject(), virtualFile2, offset);
        desc.setUseCurrentWindow(FileEditorManager.USE_CURRENT_WINDOW.isIn((UserDataHolder)navigationElement));
        return desc;
    }

    private static PsiElement getNavigatableOriginalElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/EditSourceUtil", "getNavigatableOriginalElement"));
        }
        List<? extends PsiElement> originalElements = EditSourceUtil.collectAllOriginalElements(element);
        for (PsiElement psiElement : originalElements) {
            if (!EditSourceUtil.canNavigate(psiElement)) continue;
            return psiElement;
        }
        return null;
    }

    public static boolean canNavigate(PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile(element.getNavigationElement());
        return file != null && file.isValid() && !file.is(VFileProperty.SPECIAL) && !VfsUtilCore.isBrokenLink(file);
    }

    public static void navigate(@NotNull NavigationItem item, boolean requestFocus, boolean useCurrentWindow) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/util/EditSourceUtil", "navigate"));
        }
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)useCurrentWindow);
        }
        item.navigate(requestFocus);
        if (item instanceof UserDataHolder) {
            ((UserDataHolder)item).putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        }
    }

    @NotNull
    private static List<? extends PsiElement> collectAllOriginalElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/EditSourceUtil", "collectAllOriginalElements"));
        }
        List<? extends PsiElement> result = null;
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions()) {
            result = EditSourceUtil.addAll(filter.getOriginalElements(element), result);
        }
        List list = (List)ObjectUtils.notNull(result, Collections.emptyList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/EditSourceUtil", "collectAllOriginalElements"));
        }
        return list;
    }

    @NotNull
    private static <T> List<T> addAll(@NotNull List<? extends T> elements, List<T> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/EditSourceUtil", "addAll"));
        }
        if (result == null) {
            ArrayList arrayList = ContainerUtil.newArrayList(elements);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/EditSourceUtil", "addAll"));
            }
            return arrayList;
        }
        result.addAll(elements);
        List<T> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/EditSourceUtil", "addAll"));
        }
        return list;
    }
}

