/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedSingletonsRegistry {
    private static final Object LOCK = new CachedSingletonsRegistry();
    private static final List<Class<?>> ourRegisteredClasses = new ArrayList();
    private static final List<ClearableLazyValue<?>> ourRegisteredLazyValues = new ArrayList();

    private CachedSingletonsRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T markCachedField(@NotNull Class<T> klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "com/intellij/openapi/application/CachedSingletonsRegistry", "markCachedField"));
        }
        Object object = LOCK;
        synchronized (object) {
            ourRegisteredClasses.add(klass);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> ClearableLazyValue<T> markLazyValue(@NotNull ClearableLazyValue<T> lazyValue) {
        if (lazyValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyValue", "com/intellij/openapi/application/CachedSingletonsRegistry", "markLazyValue"));
        }
        Object object = LOCK;
        synchronized (object) {
            ourRegisteredLazyValues.add(lazyValue);
        }
        ClearableLazyValue<T> clearableLazyValue = lazyValue;
        if (clearableLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/CachedSingletonsRegistry", "markLazyValue"));
        }
        return clearableLazyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupCachedFields() {
        Object object = LOCK;
        synchronized (object) {
            for (Class<?> clazz : ourRegisteredClasses) {
                try {
                    CachedSingletonsRegistry.cleanupClass(clazz);
                }
                catch (Exception exception) {}
            }
            for (ClearableLazyValue clearableLazyValue : ourRegisteredLazyValues) {
                clearableLazyValue.drop();
            }
        }
    }

    private static void cleanupClass(Class<?> aClass) throws Exception {
        ReflectionUtil.resetField(aClass, null, (String)"ourInstance");
    }
}

