/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectJdkTable {
    public static final Topic<Listener> JDK_TABLE_TOPIC = Topic.create((String)"Project JDK table", Listener.class);

    public static ProjectJdkTable getInstance() {
        return ServiceManager.getService(ProjectJdkTable.class);
    }

    @Nullable
    public abstract Sdk findJdk(String var1);

    @Nullable
    public abstract Sdk findJdk(String var1, String var2);

    @NotNull
    public abstract Sdk[] getAllJdks();

    @NotNull
    public abstract List<Sdk> getSdksOfType(@NotNull SdkTypeId var1);

    @Nullable
    public Sdk findMostRecentSdkOfType(@NotNull SdkTypeId type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/ProjectJdkTable", "findMostRecentSdkOfType"));
        }
        return this.findMostRecentSdk((Condition<Sdk>)((Condition)sdk -> {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/ProjectJdkTable", "lambda$findMostRecentSdkOfType$0"));
            }
            return sdk.getSdkType() == type;
        }));
    }

    @Nullable
    public Sdk findMostRecentSdk(@NotNull Condition<Sdk> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/projectRoots/ProjectJdkTable", "findMostRecentSdk"));
        }
        Sdk found = null;
        for (Sdk each : this.getAllJdks()) {
            if (!condition.value((Object)each)) continue;
            if (found == null) {
                found = each;
                continue;
            }
            if (Comparing.compare((Comparable)((Object)each.getVersionString()), (Comparable)((Object)found.getVersionString())) <= 0) continue;
            found = each;
        }
        return found;
    }

    public abstract void addJdk(@NotNull Sdk var1);

    public void addJdk(@NotNull Sdk jdk, @NotNull Disposable parentDisposable) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/projectRoots/ProjectJdkTable", "addJdk"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/projectRoots/ProjectJdkTable", "addJdk"));
        }
        this.addJdk(jdk);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (jdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/projectRoots/ProjectJdkTable", "lambda$addJdk$2"));
            }
            WriteAction.run(() -> {
                if (jdk == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/projectRoots/ProjectJdkTable", "lambda$null$1"));
                }
                this.removeJdk(jdk);
            });
        });
    }

    public abstract void removeJdk(@NotNull Sdk var1);

    public abstract void updateJdk(@NotNull Sdk var1, @NotNull Sdk var2);

    public abstract void addListener(@NotNull Listener var1);

    public abstract void removeListener(@NotNull Listener var1);

    @NotNull
    public abstract SdkTypeId getDefaultSdkType();

    @NotNull
    public abstract SdkTypeId getSdkTypeByName(@NotNull String var1);

    @NotNull
    public abstract Sdk createSdk(@NotNull String var1, @NotNull SdkTypeId var2);

    public static class Adapter
    implements Listener {
        @Override
        public void jdkAdded(@NotNull Sdk jdk) {
            if (jdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/projectRoots/ProjectJdkTable$Adapter", "jdkAdded"));
            }
        }

        @Override
        public void jdkRemoved(@NotNull Sdk jdk) {
            if (jdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/projectRoots/ProjectJdkTable$Adapter", "jdkRemoved"));
            }
        }

        @Override
        public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            if (jdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/projectRoots/ProjectJdkTable$Adapter", "jdkNameChanged"));
            }
            if (previousName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousName", "com/intellij/openapi/projectRoots/ProjectJdkTable$Adapter", "jdkNameChanged"));
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void jdkAdded(@NotNull Sdk var1);

        public void jdkRemoved(@NotNull Sdk var1);

        public void jdkNameChanged(@NotNull Sdk var1, @NotNull String var2);
    }
}

