/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.testFramework.fixtures.LightCodeInsightFixtureTestCase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractReparseTestCase
extends LightCodeInsightFixtureTestCase {
    protected FileType myFileType;
    protected PsiFile myDummyFile;
    private int myInsertOffset;

    @Override
    protected void tearDown() throws Exception {
        this.myDummyFile = null;
        this.myFileType = null;
        super.tearDown();
    }

    protected void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    protected void insert(@NonNls String s) throws IncorrectOperationException {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            String oldText = this.myDummyFile.getText();
            String expectedNewText = oldText.substring(0, this.myInsertOffset) + s + oldText.substring(this.myInsertOffset);
            this.doReparseAndCheck(s, expectedNewText, 0);
            this.myInsertOffset += s.length();
        }), "asd", null);
    }

    protected void moveEditPointRight(int count) {
        this.myInsertOffset += count;
    }

    protected void setEditPoint(int pos) {
        this.myInsertOffset = pos;
    }

    protected void remove(int count) throws IncorrectOperationException {
        String oldText = this.myDummyFile.getText();
        String expectedNewText = oldText.substring(0, this.myInsertOffset - count) + oldText.substring(this.myInsertOffset);
        this.doReparseAndCheck("", expectedNewText, count);
        this.myInsertOffset -= count;
    }

    private void doReparseAndCheck(String s, String expectedNewText, int length) throws IncorrectOperationException {
        this.doReparse(s, length);
        String foundStructure = DebugUtil.treeToString((ASTNode)this.myDummyFile.getNode(), (boolean)false);
        PsiFile psiFile = this.createDummyFile(this.getName() + "." + this.myFileType.getDefaultExtension(), expectedNewText);
        String expectedStructure = DebugUtil.treeToString((ASTNode)psiFile.getNode(), (boolean)false);
        AbstractReparseTestCase.assertEquals((String)expectedStructure, (String)foundStructure);
        AbstractReparseTestCase.assertEquals((String)"Reparse tree should be equal to the document", (String)expectedNewText, (String)this.myDummyFile.getText());
    }

    @NotNull
    protected PsiFile createDummyFile(@NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/psi/AbstractReparseTestCase", "createDummyFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/AbstractReparseTestCase", "createDummyFile"));
        }
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance(this.getProject()).createFileFromText(fileName, type, (CharSequence)text);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/AbstractReparseTestCase", "createDummyFile"));
        }
        return psiFile;
    }

    protected void doReparse(String s, int length) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            BlockSupport blockSupport = ServiceManager.getService(this.getProject(), BlockSupport.class);
            blockSupport.reparseRange(this.myDummyFile, this.myInsertOffset - length, this.myInsertOffset, (CharSequence)s);
        }), "asd", null);
    }

    protected void prepareFile(@NonNls String prefix, @NonNls String suffix) throws IncorrectOperationException {
        this.myDummyFile = this.createDummyFile(this.getName() + "." + this.myFileType.getDefaultExtension(), prefix + suffix);
        this.myInsertOffset = prefix.length();
    }
}

