/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.values;

import java.lang.reflect.Field;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassSerializer {
    @NotNull
    private String myInstanceName;
    @NotNull
    private final Object myInstance;

    public ClassSerializer(@NotNull String instanceName, @NotNull Object o) {
        if (instanceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceName", "com/intellij/psi/codeStyle/extractor/values/ClassSerializer", "<init>"));
        }
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/codeStyle/extractor/values/ClassSerializer", "<init>"));
        }
        this.myInstanceName = instanceName;
        this.myInstance = o;
    }

    @Nullable
    public Object read(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/extractor/values/ClassSerializer", "read"));
        }
        try {
            Field field = ClassSerializer.getPreparedField(this.myInstance.getClass().getField(name));
            if (field == null) {
                return null;
            }
            return field.get(this.myInstance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    @Contract(value="_, _, false -> null")
    public Object write(@NotNull String name, @NotNull Object value, boolean retPrevValue) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/extractor/values/ClassSerializer", "write"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/codeStyle/extractor/values/ClassSerializer", "write"));
        }
        try {
            Field field = ClassSerializer.getPreparedField(this.myInstance.getClass().getField(name));
            if (field != null) {
                Object ret = retPrevValue ? field.get(this.myInstance) : null;
                field.set(this.myInstance, value);
                return ret;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public static Field getPreparedField(Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        if ((field.getModifiers() & 8) != 0) {
            return null;
        }
        if (type != Integer.TYPE && type != Boolean.TYPE) {
            return null;
        }
        if (field.getName().startsWith("my")) {
            return null;
        }
        return field;
    }

    @NotNull
    public String getInstanceName() {
        String string = this.myInstanceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/values/ClassSerializer", "getInstanceName"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (o instanceof ClassSerializer) {
            ClassSerializer other = (ClassSerializer)o;
            return other.myInstance.equals(this.myInstance);
        }
        return false;
    }

    public int hashCode() {
        return this.myInstance.hashCode();
    }
}

