/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.spring.contexts.model.AbstractSimpleSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeansSpringModel
extends AbstractSimpleSpringModel {
    private final NotNullLazyValue<Collection<? extends SpringBeanPointer>> myPointers;
    private final Module myModule;

    public BeansSpringModel(@Nullable Module module, final @NotNull Set<PsiClass> classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/spring/contexts/model/BeansSpringModel", "<init>"));
        }
        this(module, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

            @NotNull
            protected Collection<? extends SpringBeanPointer> compute() {
                BeanService beanService = BeanService.getInstance();
                LinkedHashSet<SpringBeanPointer> pointers = new LinkedHashSet<SpringBeanPointer>(classes.size());
                for (PsiClass psiClass : classes) {
                    if (!psiClass.isValid()) continue;
                    pointers.add(beanService.createSpringBeanPointer(new CustomSpringComponent(psiClass)));
                }
                LinkedHashSet<SpringBeanPointer> linkedHashSet = pointers;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/BeansSpringModel$1", "compute"));
                }
                return linkedHashSet;
            }
        });
    }

    public BeansSpringModel(@Nullable Module module, @NotNull NotNullLazyValue<Collection<? extends SpringBeanPointer>> pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/spring/contexts/model/BeansSpringModel", "<init>"));
        }
        assert (!(pointers instanceof AtomicNotNullLazyValue));
        this.myModule = module;
        this.myPointers = pointers;
    }

    @Override
    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        return (Collection)this.myPointers.getValue();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @Override
    @NotNull
    public Set<String> getAllProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/BeansSpringModel", "getAllProfiles"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set<PsiFile> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/BeansSpringModel", "getConfigFiles"));
        }
        return set;
    }

    @Override
    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/BeansSpringModel", "hasConfigFile"));
        }
        return false;
    }
}

