/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.javaConfig;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContextJavaBean
extends SpringJavaBean {
    public static final SemKey<JamAnnotationMeta> BEAN_ANNOTATION_KEY = JamService.ANNO_META_KEY.subKey("ContextJavaBean", new SemKey[0]);
    public static final SemKey<ContextJavaBean> BEAN_JAM_KEY = JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY.subKey("ContextJavaBean", new SemKey[0]);
    public static final JamMethodMeta<ContextJavaBean> METHOD_META = new JamMethodMeta(null, ContextJavaBean.class, BEAN_JAM_KEY);
    private static final JamStringAttributeMeta.Collection<String> NAME_VALUE_META = JamAttributeMeta.collectionString((String)"name");
    private static final JamStringAttributeMeta.Single<PsiMethod> INIT_METHOD_META = JamAttributeMeta.singleString((String)"initMethod", (JamConverter)new PsiMethodReferenceConverter());
    private static final JamStringAttributeMeta.Single<PsiMethod> DESTROY_METHOD_META = JamAttributeMeta.singleString((String)"destroyMethod", (JamConverter)new PsiMethodReferenceConverter());
    public static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.context.annotation.Bean").addAttribute(NAME_VALUE_META).addAttribute(INIT_METHOD_META).addAttribute(DESTROY_METHOD_META);

    @Override
    public PsiAnnotation getPsiAnnotation() {
        return ANNOTATION_META.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    @Override
    public String getBeanName() {
        List<JamStringAttributeElement<String>> elements = this.getNamedAttributeValue();
        if (elements.size() > 0) {
            return (String)elements.get(0).getValue();
        }
        return super.getBeanName();
    }

    @NotNull
    public JamStringAttributeElement<PsiMethod> getInitMethodAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)ANNOTATION_META.getAttribute((PsiModifierListOwner)this.getPsiElement(), INIT_METHOD_META);
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/ContextJavaBean", "getInitMethodAttributeElement"));
        }
        return jamStringAttributeElement;
    }

    @NotNull
    public JamStringAttributeElement<PsiMethod> getDestroyMethodAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)ANNOTATION_META.getAttribute((PsiModifierListOwner)this.getPsiElement(), DESTROY_METHOD_META);
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/ContextJavaBean", "getDestroyMethodAttributeElement"));
        }
        return jamStringAttributeElement;
    }

    @Override
    @NotNull
    public String[] getAliases() {
        List<JamStringAttributeElement<String>> elements = this.getNamedAttributeValue();
        if (elements.size() < 2) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/ContextJavaBean", "getAliases"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        List<String> aliases = this.getStringNames(elements);
        String[] stringArray = ArrayUtil.toStringArray(aliases);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/ContextJavaBean", "getAliases"));
        }
        return stringArray;
    }

    public List<PomNamedTarget> getPomTargets() {
        LinkedList<PomNamedTarget> pomTargets = new LinkedList<PomNamedTarget>();
        List<JamStringAttributeElement<String>> elements = this.getNamedAttributeValue();
        if (!elements.isEmpty()) {
            for (JamStringAttributeElement<String> attributeElement : elements) {
                pomTargets.add((PomNamedTarget)new JamPomTarget((JamElement)this, attributeElement));
            }
        } else {
            pomTargets.add((PomNamedTarget)this.getPsiElement());
        }
        return pomTargets;
    }

    protected List<JamStringAttributeElement<String>> getNamedAttributeValue() {
        return (List)ANNOTATION_META.getAttribute((PsiModifierListOwner)this.getPsiElement(), NAME_VALUE_META);
    }

    @Override
    public PsiNamedElement getIdentifyingPsiElement() {
        PsiElement psiElement;
        PsiTarget psiTarget = this.getPsiTarget();
        if (psiTarget != null && (psiElement = PomService.convertToPsi((Project)this.getPsiManager().getProject(), (PomTarget)psiTarget)) instanceof PsiNamedElement) {
            return (PsiNamedElement)psiElement;
        }
        return super.getIdentifyingPsiElement();
    }

    @Nullable
    public PsiTarget getPsiTarget() {
        List<JamStringAttributeElement<String>> namedAttributeValue = this.getNamedAttributeValue();
        if (namedAttributeValue == null || namedAttributeValue.size() == 0) {
            return null;
        }
        return new JamPomTarget((JamElement)this, namedAttributeValue.get(0));
    }

    static {
        METHOD_META.addAnnotation(ANNOTATION_META);
        METHOD_META.addPomTargetProducer((contextJavaBean, consumer) -> consumer.consume((Object)contextJavaBean.getPsiTarget()));
    }

    private static class PsiMethodReferenceConverter
    extends JamSimpleReferenceConverter<PsiMethod> {
        private PsiMethodReferenceConverter() {
        }

        public PsiMethod fromString(@Nullable String s, JamStringAttributeElement<PsiMethod> context) {
            for (PsiMethod psiMethod : PsiMethodReferenceConverter.getAppropriateMethods(context)) {
                if (!psiMethod.getName().equals(s)) continue;
                return psiMethod;
            }
            return null;
        }

        private static List<PsiMethod> getAppropriateMethods(JamStringAttributeElement<PsiMethod> context) {
            PsiClass psiClass;
            PsiType type;
            ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context.getPsiElement(), PsiMethod.class);
            if (method != null && (type = method.getReturnType()) instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null) {
                for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                    if (psiMethod.isConstructor() || psiMethod.getParameterList().getParametersCount() != 0) continue;
                    methods.add(psiMethod);
                }
            }
            return methods;
        }

        public Collection<PsiMethod> getVariants(JamStringAttributeElement<PsiMethod> context) {
            ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
            for (PsiMethod method : PsiMethodReferenceConverter.getAppropriateMethods(context)) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
                methods.add(method);
            }
            return methods;
        }
    }
}

