/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.converters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.converters.SpringImportResourceConverter;
import com.intellij.spring.model.jam.testContexts.converters.ResourcePathReferenceConverter;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationContextReferenceConverter
extends ResourcePathReferenceConverter<XmlFile> {
    @Override
    protected Function<ResolveResult, XmlFile> getMapper() {
        return SpringImportResourceConverter.XML_FILE_MAPPER;
    }

    @NotNull
    public static List<XmlFile> getApplicationContexts(@Nullable String path, @NotNull PsiElement context, Module ... modules) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/model/jam/testContexts/converters/ApplicationContextReferenceConverter", "getApplicationContexts"));
        }
        List<XmlFile> list = path == null ? Collections.emptyList() : SpringImportResourceConverter.getFiles(ApplicationContextReferenceConverter.getReferencesOnFakeElement(context, path, modules));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/converters/ApplicationContextReferenceConverter", "getApplicationContexts"));
        }
        return list;
    }
}

