/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.attributes.MultipleCandidatesDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOrderedDisambiguationRule<T>
implements Action<MultipleCandidatesDetails<T>> {
    private final Comparator<? super T> comparator;
    private final boolean pickFirst;

    public DefaultOrderedDisambiguationRule(Comparator<? super T> comparator, boolean pickFirst) {
        this.comparator = comparator;
        this.pickFirst = pickFirst;
    }

    public void execute(MultipleCandidatesDetails<T> details) {
        Object cmp;
        Set<T> values = details.getCandidateValues();
        Object min = null;
        Object max = null;
        for (Object value : values) {
            if (min == null || this.comparator.compare(value, min) < 0) {
                min = value;
            }
            if (max != null && this.comparator.compare(value, max) <= 0) continue;
            max = value;
        }
        Object t = cmp = this.pickFirst ? min : max;
        if (cmp != null) {
            for (Object value : details.getCandidateValues()) {
                if (!value.equals(cmp)) continue;
                details.closestMatch(value);
            }
        }
    }
}

