/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.LengthUnit;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataType
implements Serializable {
    public static final int MAX_SIZE = Integer.MAX_VALUE;
    public static final int STAR_SIZE = 0x7FFFFFFE;
    public static final int NO_SIZE = -1;
    public static final int NO_SCALE = 0;
    public static final DataType UNKNOWN = new DataType(null, "unknown", -1, 0, LengthUnit.NONE, false, null, null, false, Collections.emptyList(), Collections.emptySet(), 0);
    @NotNull
    public final Set<Feature> features;
    @Nullable
    public final String schemaName;
    @NotNull
    public final String typeName;
    public final int size;
    public final int scale;
    @NotNull
    public final LengthUnit sizeUnit;
    public final String vagueArg;
    @Nullable
    public final String suffix;
    public final boolean sizeUnitExplicit;
    public final boolean custom;
    @Nullable
    public final List<String> enumValues;
    @Deprecated
    public final int jdbcType;

    public DataType(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, boolean sizeUnitExplicit, @Nullable String vagueArg, @Nullable String suffix, boolean custom, @Nullable List<String> enumValues, @NotNull Set<Feature> features, int jdbcType) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/model/DataType", "<init>"));
        }
        if (features == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "features", "com/intellij/database/model/DataType", "<init>"));
        }
        this.features = features;
        this.schemaName = DbUtil.intern2(schemaName);
        this.typeName = DbUtil.intern2(typeName);
        this.size = size;
        this.scale = scale;
        this.sizeUnit = sizeUnit != null ? sizeUnit : LengthUnit.NONE;
        this.vagueArg = DbUtil.intern2(vagueArg);
        this.suffix = DbUtil.intern2(suffix);
        this.custom = custom;
        this.sizeUnitExplicit = sizeUnitExplicit;
        this.jdbcType = jdbcType;
        this.enumValues = enumValues == null || enumValues.isEmpty() ? null : ContainerUtil.immutableList(enumValues);
    }

    @NotNull
    public String getSpecification() {
        if (this.schemaName == null && this.vagueArg == null && this.enumValues == null && this.size < 0 && this.suffix == null) {
            String string = this.typeName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataType", "getSpecification"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(12);
        if (this.schemaName != null) {
            sb.append(this.schemaName).append('.');
        }
        sb.append(this.typeName);
        if (this.vagueArg != null) {
            sb.append('(').append(this.vagueArg).append(')');
        } else if (this.enumValues != null) {
            sb.append('(');
            StringUtil.join(this.enumValues, (String)", ", (StringBuilder)sb);
            sb.append(')');
        } else if (this.size >= 0) {
            sb.append('(');
            if (this.size == 0x7FFFFFFE) {
                sb.append('*');
            } else if (this.size == Integer.MAX_VALUE) {
                sb.append("max");
            } else {
                sb.append(this.size);
            }
            if (this.scale != 0) {
                sb.append(',').append(this.scale);
            }
            if (this.sizeUnit != LengthUnit.NONE && this.sizeUnitExplicit) {
                sb.append(' ').append(this.sizeUnit.suffix.toLowerCase(Locale.ENGLISH));
            }
            sb.append(')');
        }
        if (this.suffix != null) {
            sb.append(' ').append(this.suffix);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/DataType", "getSpecification"));
        }
        return string;
    }

    public int getLength() {
        return this.size;
    }

    public int getPrecision() {
        return this.size;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.equals((DataType)that);
    }

    public boolean equals(@NotNull DataType that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/database/model/DataType", "equals"));
        }
        if (this == that) {
            return true;
        }
        if (this.size != that.size) {
            return false;
        }
        if (this.scale != that.scale) {
            return false;
        }
        if (this.sizeUnit != that.sizeUnit) {
            return false;
        }
        if (this.custom != that.custom) {
            return false;
        }
        if (this.sizeUnitExplicit != that.sizeUnitExplicit) {
            return false;
        }
        if (this.jdbcType != that.jdbcType) {
            return false;
        }
        if (!Comparing.equal((String)this.schemaName, (String)that.schemaName)) {
            return false;
        }
        if (!Comparing.equal((String)this.vagueArg, (String)that.vagueArg)) {
            return false;
        }
        if (!Comparing.equal((String)this.typeName, (String)that.typeName)) {
            return false;
        }
        if (!Comparing.equal((String)this.suffix, (String)that.suffix)) {
            return false;
        }
        return Comparing.equal(this.enumValues, that.enumValues);
    }

    public int hashCode() {
        int result = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result = 31 * result + this.typeName.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + this.scale;
        result = 31 * result + this.sizeUnit.hashCode();
        result = 31 * result + (this.vagueArg != null ? this.vagueArg.hashCode() : 0);
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        result = 31 * result + (this.sizeUnitExplicit ? 1 : 0);
        result = 31 * result + (this.custom ? 1 : 0);
        result = 31 * result + (this.enumValues != null ? this.enumValues.hashCode() : 0);
        result = 31 * result + this.jdbcType;
        return result;
    }

    public String toString() {
        return this.getSpecification();
    }

    public static enum Feature {
        isBoolean,
        isNumber,
        isText,
        isCollection,
        isStruct,
        comparable,
        orderable,
        alwaysNotNull;

    }
}

