/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.DocumentAccessor;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class LabelWithEditLink
extends JPanel
implements DocumentAccessor {
    private static final String EDIT_TEXT = "<html><a>Edit</a></html>";
    private static final String DONE_TEXT = "<html><a>Done</a></html>";
    private final HyperlinkLabel myLinkLabel = new HyperlinkLabel();
    private final JTextField myTextField = new JTextField(){

        @Override
        public Border getBorder() {
            return this.isEnabled() ? super.getBorder() : BorderFactory.createEmptyBorder();
        }

        @Override
        public Color getBackground() {
            return this.isEnabled() || this.getParent() == null ? super.getBackground() : this.getParent().getBackground();
        }
    };

    public LabelWithEditLink() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.myTextField);
        this.add((Component)this.myLinkLabel);
        this.myLinkLabel.setHtmlText(EDIT_TEXT);
        this.myTextField.setEnabled(false);
        this.myLinkLabel.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                this.toggleEdit();
            }
        });
        this.setFont(UIUtil.getLabelFont());
    }

    private void toggleEdit() {
        boolean isEnabled = this.myTextField.isEnabled();
        this.myLinkLabel.setHtmlText(isEnabled ? EDIT_TEXT : DONE_TEXT);
        this.myTextField.setEnabled(!isEnabled);
        if (!isEnabled) {
            this.myTextField.requestFocusInWindow();
        }
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/adtui/LabelWithEditLink", "setText"));
        }
        this.myTextField.setText(text);
    }

    @NotNull
    public String getText() {
        String string = this.myTextField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/LabelWithEditLink", "getText"));
        }
        return string;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font != null && this.myLinkLabel != null) {
            this.myTextField.setFont(font);
            float smallFontSize = font.getSize() - 1;
            Font smallerFont = smallFontSize <= 0.0f ? font : font.deriveFont(smallFontSize);
            this.myLinkLabel.setFont(smallerFont);
        }
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myTextField.getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/LabelWithEditLink", "getDocument"));
        }
        return document;
    }
}

