/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common.formatter;

import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public class SingleUnitAxisFormatter
extends BaseAxisFormatter {
    private static final int MULTIPLIER = 1;
    private static final int BASE = 10;
    private static final int UNITS_COUNT = 1;
    private static final TIntArrayList BASE_FACTORS = SingleUnitAxisFormatter.getMultiplierFactors(10);
    private final int mUnitMinimalInterval;
    private final String mUnit;

    public SingleUnitAxisFormatter(int maxMinorTicks, int maxMajorTicks, int unitMinimalInterval, String unit) {
        super(maxMinorTicks, maxMajorTicks, 1);
        this.mUnitMinimalInterval = unitMinimalInterval;
        this.mUnit = unit;
    }

    @Override
    protected int getNumUnits() {
        return 1;
    }

    @Override
    protected int getUnitBase(int index) {
        return 10;
    }

    @Override
    protected int getUnitMultiplier(int index) {
        return 1;
    }

    @Override
    @NotNull
    protected TIntArrayList getUnitBaseFactors(int index) {
        TIntArrayList tIntArrayList = BASE_FACTORS;
        if (tIntArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/common/formatter/SingleUnitAxisFormatter", "getUnitBaseFactors"));
        }
        return tIntArrayList;
    }

    @Override
    @NotNull
    protected String getUnit(int index) {
        String string = this.mUnit;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/common/formatter/SingleUnitAxisFormatter", "getUnit"));
        }
        return string;
    }

    @Override
    protected int getUnitMinimalInterval(int index) {
        return this.mUnitMinimalInterval;
    }
}

