/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.Layout;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AttachedToolWindow<T>
implements Disposable {
    static final String TOOL_WINDOW_PROPERTY_PREFIX = "ATTACHED_TOOL_WINDOW.";
    static final String TOOL_WINDOW_TOOLBAR_PLACE = "TOOL_WINDOW_TOOLBAR";
    static final String LABEL_HEADER = "LABEL";
    static final String SEARCH_HEADER = "SEARCH";
    private final String myWorkBenchName;
    private final ToolWindowDefinition<T> myDefinition;
    private final PropertiesComponent myPropertiesComponent;
    private final SideModel<T> myModel;
    private final JPanel myPanel;
    private final List<UpdatableActionButton> myActionButtons;
    private final AbstractButton myMinimizedButton;
    private final ButtonDragListener<T> myDragListener;
    private final SearchTextField mySearchField;
    private final ActionButton mySearchActionButton;
    @Nullable
    private ToolContent<T> myContent;
    private boolean myAutoHideOpen;
    private int myToolOrder;

    public AttachedToolWindow(@NotNull ToolWindowDefinition<T> definition, @NotNull ButtonDragListener<T> dragListener, @NotNull String workBenchName, @NotNull SideModel<T> model) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/android/tools/adtui/workbench/AttachedToolWindow", "<init>"));
        }
        if (dragListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dragListener", "com/android/tools/adtui/workbench/AttachedToolWindow", "<init>"));
        }
        if (workBenchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workBenchName", "com/android/tools/adtui/workbench/AttachedToolWindow", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/AttachedToolWindow", "<init>"));
        }
        this.myWorkBenchName = workBenchName;
        this.myDefinition = definition;
        this.myDragListener = dragListener;
        this.myPropertiesComponent = PropertiesComponent.getInstance();
        this.myModel = model;
        this.myPanel = new JPanel(new BorderLayout());
        this.myActionButtons = new ArrayList<UpdatableActionButton>(4);
        this.myMinimizedButton = new MinimizedButton(definition.getTitle(), definition.getIcon(), this);
        this.mySearchField = new MySearchField();
        this.mySearchActionButton = this.createActionButton(new SearchAction(), this.myDefinition.getButtonSize());
        this.setDefaultProperty(PropertyType.LEFT, definition.getSide().isLeft());
        this.setDefaultProperty(PropertyType.SPLIT, definition.getSplit().isBottom());
        this.setDefaultProperty(PropertyType.AUTO_HIDE, definition.getAutoHide().isAutoHide());
        this.updateContent();
        DumbService.getInstance((Project)model.getProject()).smartInvokeLater(this::updateActions);
        this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (AttachedToolWindow.this.myContent != null) {
                    AttachedToolWindow.this.myContent.setFilter(AttachedToolWindow.this.mySearchField.getText().trim());
                }
            }
        });
    }

    public void dispose() {
        if (this.myContent != null) {
            Disposer.dispose(this.myContent);
            this.myContent = null;
        }
    }

    @NotNull
    public String getToolName() {
        String string = this.myDefinition.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow", "getToolName"));
        }
        return string;
    }

    public int getToolOrder() {
        return this.myToolOrder;
    }

    public void setToolOrder(int order) {
        this.myToolOrder = order;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public AbstractButton getMinimizedButton() {
        AbstractButton abstractButton = this.myMinimizedButton;
        if (abstractButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow", "getMinimizedButton"));
        }
        return abstractButton;
    }

    @Nullable
    public T getContext() {
        return this.myModel.getContext();
    }

    public ToolWindowDefinition<T> getDefinition() {
        return this.myDefinition;
    }

    public boolean isMinimized() {
        return this.getProperty(PropertyType.MINIMIZED);
    }

    public void setMinimized(boolean value) {
        this.setProperty(PropertyType.MINIMIZED, value);
    }

    public boolean isLeft() {
        return this.getProperty(PropertyType.LEFT);
    }

    public void setLeft(boolean value) {
        this.setProperty(PropertyType.LEFT, value);
    }

    public boolean isSplit() {
        return this.getProperty(PropertyType.SPLIT);
    }

    public void setSplit(boolean value) {
        this.setProperty(PropertyType.SPLIT, value);
    }

    public boolean isAutoHide() {
        return this.getProperty(PropertyType.AUTO_HIDE);
    }

    public void setAutoHide(boolean value) {
        this.setProperty(PropertyType.AUTO_HIDE, value);
    }

    public boolean isFloating() {
        return this.getProperty(PropertyType.FLOATING);
    }

    public void setFloating(boolean value) {
        this.setProperty(PropertyType.FLOATING, value);
    }

    public boolean getProperty(@NotNull PropertyType property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow", "getProperty"));
        }
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            return !this.myAutoHideOpen;
        }
        return this.getLayoutProperty(Layout.CURRENT, property);
    }

    public void setProperty(@NotNull PropertyType property, boolean value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow", "setProperty"));
        }
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            this.myAutoHideOpen = !value;
        } else {
            this.setLayoutProperty(Layout.CURRENT, property, value);
        }
        if (this.myMinimizedButton != null) {
            this.myMinimizedButton.setSelected(!this.isMinimized());
        }
    }

    private boolean getLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/adtui/workbench/AttachedToolWindow", "getLayoutProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow", "getLayoutProperty"));
        }
        return this.myPropertiesComponent.getBoolean(this.getPropertyName(layout, property));
    }

    private void setLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property, boolean value) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/adtui/workbench/AttachedToolWindow", "setLayoutProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow", "setLayoutProperty"));
        }
        this.myPropertiesComponent.setValue(this.getPropertyName(layout, property), value);
    }

    public void setDefaultProperty(@NotNull PropertyType property, boolean defaultValue) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow", "setDefaultProperty"));
        }
        if (!this.myPropertiesComponent.isValueSet(this.getPropertyName(Layout.DEFAULT, property))) {
            this.setLayoutProperty(Layout.DEFAULT, property, defaultValue);
            this.setLayoutProperty(Layout.CURRENT, property, defaultValue);
        }
    }

    private String getPropertyName(@NotNull Layout layout, @NotNull PropertyType property) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/adtui/workbench/AttachedToolWindow", "getPropertyName"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow", "getPropertyName"));
        }
        return TOOL_WINDOW_PROPERTY_PREFIX + layout.getPrefix() + this.myWorkBenchName + "." + this.myDefinition.getName() + "." + property.name();
    }

    public void setPropertyAndUpdate(@NotNull PropertyType property, boolean value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow", "setPropertyAndUpdate"));
        }
        this.setProperty(property, value);
        this.updateContent();
        this.updateActions();
        this.myModel.update(this, property);
        if (property == PropertyType.MINIMIZED && !value && this.myContent != null) {
            this.myContent.getFocusedComponent().requestFocus();
        }
    }

    public void storeDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setLayoutProperty(Layout.DEFAULT, property, this.getLayoutProperty(Layout.CURRENT, property));
        }
    }

    public void restoreDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setProperty(property, this.getLayoutProperty(Layout.DEFAULT, property));
        }
    }

    public void setContext(T context) {
        if (this.myContent != null) {
            this.myContent.setToolContext(context);
        }
    }

    @Nullable
    ToolContent<T> getContent() {
        return this.myContent;
    }

    private void updateContent() {
        if (this.isFloating() && this.myContent != null) {
            this.myPanel.removeAll();
            this.myContent.setToolContext(null);
            Disposer.dispose(this.myContent);
            this.myContent = null;
        } else if (!this.isFloating() && this.myContent == null) {
            this.myContent = (ToolContent)this.myDefinition.getFactory().create();
            assert (this.myContent != null);
            this.myContent.setToolContext(this.myModel.getContext());
            this.myContent.registerCloseAutoHideWindow(this::closeAutoHideWindow);
            this.myPanel.add((Component)this.createHeader(this.myContent.supportsFiltering(), this.myContent.getAdditionalActions()), "North");
            this.myPanel.add((Component)this.myContent.getComponent(), "Center");
        }
    }

    private void closeAutoHideWindow() {
        if (!this.isFloating() && this.isAutoHide() && !this.isMinimized()) {
            this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }
    }

    @NotNull
    private JComponent createHeader(boolean includeSearchButton, @NotNull List<AnAction> additionalActions) {
        if (additionalActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalActions", "com/android/tools/adtui/workbench/AttachedToolWindow", "createHeader"));
        }
        JPanel header = new JPanel(new BorderLayout());
        header.add((Component)AttachedToolWindow.createTitlePanel(this.myDefinition.getTitle(), includeSearchButton, this.mySearchField), "Center");
        header.add((Component)this.createActionPanel(includeSearchButton, additionalActions), "East");
        header.setBorder(IdeBorderFactory.createBorder((int)8));
        JPanel jPanel = header;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow", "createHeader"));
        }
        return jPanel;
    }

    @NotNull
    private static JPanel createTitlePanel(@NotNull String title, boolean includeSearchField, @NotNull SearchTextField searchField) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/adtui/workbench/AttachedToolWindow", "createTitlePanel"));
        }
        if (searchField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchField", "com/android/tools/adtui/workbench/AttachedToolWindow", "createTitlePanel"));
        }
        CardLayout layout = new CardLayout();
        JPanel titlePanel = new JPanel(layout);
        JBLabel titleLabel = new JBLabel(title);
        titleLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)5, (int)2, (int)10));
        titleLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        titlePanel.add((Component)titleLabel, LABEL_HEADER);
        if (includeSearchField) {
            searchField.setPreferredSize(new Dimension(searchField.getPreferredSize().width, titlePanel.getPreferredSize().height));
            titlePanel.add((Component)searchField, SEARCH_HEADER);
        }
        layout.show(titlePanel, LABEL_HEADER);
        JPanel jPanel = titlePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow", "createTitlePanel"));
        }
        return jPanel;
    }

    private void showSearchField(boolean show) {
        Container parent = this.mySearchField.getParent();
        CardLayout layout = (CardLayout)parent.getLayout();
        if (show) {
            layout.show(parent, SEARCH_HEADER);
            this.mySearchField.requestFocus();
        } else {
            layout.show(parent, LABEL_HEADER);
        }
        this.mySearchActionButton.setVisible(!show);
    }

    @NotNull
    private JComponent createActionPanel(boolean includeSearchButton, @NotNull List<AnAction> additionalActions) {
        if (additionalActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalActions", "com/android/tools/adtui/workbench/AttachedToolWindow", "createActionPanel"));
        }
        Dimension buttonSize = this.myDefinition.getButtonSize();
        int border = buttonSize.equals(ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE) ? 2 : 0;
        JPanel actionPanel = new JPanel(new FlowLayout(1, 0, 0));
        actionPanel.setOpaque(false);
        actionPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)border, (int)0, (int)border, (int)0));
        if (includeSearchButton) {
            actionPanel.add((Component)this.mySearchActionButton);
            this.mySearchActionButton.setVisible(true);
        }
        if (!additionalActions.isEmpty()) {
            additionalActions.forEach(action -> actionPanel.add((Component)this.createActionButton((AnAction)action, buttonSize)));
            actionPanel.add(new JLabel(AllIcons.General.Divider));
        }
        actionPanel.add((Component)this.createActionButton(new GearAction(), buttonSize));
        actionPanel.add((Component)this.createActionButton(new HideAction(), buttonSize));
        JPanel jPanel = actionPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow", "createActionPanel"));
        }
        return jPanel;
    }

    @NotNull
    private ActionButton createActionButton(@NotNull AnAction action, @NotNull Dimension buttonSize) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/adtui/workbench/AttachedToolWindow", "createActionButton"));
        }
        if (buttonSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttonSize", "com/android/tools/adtui/workbench/AttachedToolWindow", "createActionButton"));
        }
        UpdatableActionButton button = new UpdatableActionButton(action, buttonSize);
        this.myActionButtons.add(button);
        UpdatableActionButton updatableActionButton = button;
        if (updatableActionButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow", "createActionButton"));
        }
        return updatableActionButton;
    }

    private void updateActions() {
        this.myActionButtons.forEach(UpdatableActionButton::update);
    }

    private void showGearPopup(@NotNull Component component, int x, int y) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/adtui/workbench/AttachedToolWindow", "showGearPopup"));
        }
        DefaultActionGroup group = new DefaultActionGroup();
        this.addGearPopupActions(group);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)group);
        popupMenu.getComponent().show(component, x, y);
    }

    private void addGearPopupActions(@NotNull DefaultActionGroup group) {
        List<AnAction> myExtraGearActions;
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/adtui/workbench/AttachedToolWindow", "addGearPopupActions"));
        }
        if (this.myContent != null && !(myExtraGearActions = this.myContent.getGearActions()).isEmpty()) {
            group.addAll(myExtraGearActions);
            group.addSeparator();
        }
        DefaultActionGroup attachedSide = new DefaultActionGroup("Attached Side", true);
        attachedSide.add((AnAction)new TogglePropertyTypeAction(PropertyType.LEFT, "Left"));
        attachedSide.add((AnAction)new ToggleOppositePropertyTypeAction(PropertyType.LEFT, "Right"));
        attachedSide.add((AnAction)new SwapAction());
        group.add((AnAction)attachedSide);
        ActionManager manager = ActionManager.getInstance();
        group.add((AnAction)new ToggleOppositePropertyTypeAction(PropertyType.AUTO_HIDE, manager.getAction("ToggleDockMode")));
        group.add((AnAction)new TogglePropertyTypeAction(PropertyType.FLOATING, manager.getAction("ToggleFloatingMode")));
        group.add((AnAction)new TogglePropertyTypeAction(PropertyType.SPLIT, manager.getAction("ToggleSideMode")));
    }

    void fireButtonDragged(@NotNull DragEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow", "fireButtonDragged"));
        }
        this.myDragListener.buttonDragged(this, event);
    }

    void fireButtonDropped(@NotNull DragEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow", "fireButtonDropped"));
        }
        this.myDragListener.buttonDropped(this, event);
    }

    private class MySearchField
    extends SearchTextField {
        private MySearchField() {
        }

        protected void onFocusLost() {
            if (this.getText().trim().isEmpty()) {
                AttachedToolWindow.this.showSearchField(false);
            }
        }
    }

    private class SwapAction
    extends AnAction {
        public SwapAction() {
            super("Swap");
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$SwapAction", "actionPerformed"));
            }
            AttachedToolWindow.this.myModel.swap();
            AttachedToolWindow.this.updateActions();
        }
    }

    private class ToggleOppositePropertyTypeAction
    extends TogglePropertyTypeAction {
        public ToggleOppositePropertyTypeAction(@NotNull PropertyType property, String text) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow$ToggleOppositePropertyTypeAction", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/adtui/workbench/AttachedToolWindow$ToggleOppositePropertyTypeAction", "<init>"));
            }
            super(property, text);
        }

        public ToggleOppositePropertyTypeAction(@NotNull PropertyType property, AnAction action) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow$ToggleOppositePropertyTypeAction", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/adtui/workbench/AttachedToolWindow$ToggleOppositePropertyTypeAction", "<init>"));
            }
            super(property, action);
        }

        @Override
        public boolean isSelected(AnActionEvent event) {
            return !super.isSelected(event);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$ToggleOppositePropertyTypeAction", "setSelected"));
            }
            super.setSelected(event, !state);
        }
    }

    private class TogglePropertyTypeAction
    extends ToggleAction {
        private final PropertyType myProperty;

        public TogglePropertyTypeAction(@NotNull PropertyType property, String text) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow$TogglePropertyTypeAction", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/adtui/workbench/AttachedToolWindow$TogglePropertyTypeAction", "<init>"));
            }
            super(text);
            this.myProperty = property;
        }

        public TogglePropertyTypeAction(@NotNull PropertyType property, AnAction action) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/adtui/workbench/AttachedToolWindow$TogglePropertyTypeAction", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/adtui/workbench/AttachedToolWindow$TogglePropertyTypeAction", "<init>"));
            }
            this.myProperty = property;
            this.copyFrom(action);
        }

        public boolean isSelected(AnActionEvent event) {
            return AttachedToolWindow.this.getProperty(this.myProperty);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$TogglePropertyTypeAction", "setSelected"));
            }
            AttachedToolWindow.this.setPropertyAndUpdate(this.myProperty, state);
        }
    }

    private class HideAction
    extends AnAction {
        public HideAction() {
            super(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]));
            this.update(this.getTemplatePresentation());
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$HideAction", "update"));
            }
            this.update(event.getPresentation());
        }

        private void update(@NotNull Presentation presentation) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/android/tools/adtui/workbench/AttachedToolWindow$HideAction", "update"));
            }
            if (AttachedToolWindow.this.isLeft()) {
                presentation.setIcon(AllIcons.General.HideLeftPart);
                presentation.setHoveredIcon(AllIcons.General.HideLeftPartHover);
            } else {
                presentation.setIcon(AllIcons.General.HideRightPart);
                presentation.setHoveredIcon(AllIcons.General.HideRightPartHover);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$HideAction", "actionPerformed"));
            }
            AttachedToolWindow.this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }
    }

    private class GearAction
    extends AnAction {
        public GearAction() {
            super("Gear");
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.General.Gear);
            presentation.setHoveredIcon(AllIcons.General.GearHover);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/adtui/workbench/AttachedToolWindow$GearAction", "actionPerformed"));
            }
            int x = 0;
            int y = 0;
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            AttachedToolWindow.this.showGearPopup(inputEvent.getComponent(), x, y);
        }
    }

    private class SearchAction
    extends AnAction {
        public SearchAction() {
            super("Search");
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.FindPlain);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$SearchAction", "actionPerformed"));
            }
            AttachedToolWindow.this.showSearchField(true);
        }
    }

    private static class UpdatableActionButton
    extends ActionButton {
        private UpdatableActionButton(@NotNull AnAction action, @NotNull Dimension buttonSize) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/adtui/workbench/AttachedToolWindow$UpdatableActionButton", "<init>"));
            }
            if (buttonSize == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttonSize", "com/android/tools/adtui/workbench/AttachedToolWindow$UpdatableActionButton", "<init>"));
            }
            super(action, action.getTemplatePresentation().clone(), AttachedToolWindow.TOOL_WINDOW_TOOLBAR_PLACE, buttonSize);
        }

        public void update() {
            AnActionEvent event = new AnActionEvent(null, this.getDataContext(), this.myPlace, this.myPresentation, ActionManager.getInstance(), 0);
            ActionUtil.performDumbAwareUpdate((AnAction)this.myAction, (AnActionEvent)event, (boolean)false);
        }
    }

    private static class MinimizedButton
    extends AnchoredButton {
        private final AttachedToolWindow myToolWindow;
        private JLabel myDragImage;
        private Point myStartDragPosition;

        public MinimizedButton(@NotNull String title, @NotNull Icon icon, @NotNull AttachedToolWindow toolWindow) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton", "<init>"));
            }
            if (toolWindow == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton", "<init>"));
            }
            super(title, icon);
            this.myToolWindow = toolWindow;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            this.setFocusable(false);
            this.setRolloverEnabled(true);
            this.setOpaque(true);
            this.setSelected(!toolWindow.isMinimized());
            MouseInputAdapter listener = new MouseInputAdapter(){

                @Override
                public void mouseDragged(@NotNull MouseEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton$1", "mouseDragged"));
                    }
                    this.handleDragging(event);
                }

                @Override
                public void mouseReleased(@NotNull MouseEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton$1", "mouseReleased"));
                    }
                    this.stopDragging(event);
                }

                @Override
                public void mouseClicked(@NotNull MouseEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton$1", "mouseClicked"));
                    }
                    if (event.getButton() <= 1) {
                        this.setSelected(false);
                        myToolWindow.setPropertyAndUpdate(PropertyType.MINIMIZED, !myToolWindow.isMinimized());
                    } else {
                        myToolWindow.showGearPopup((Component)((Object)this), event.getX(), event.getY());
                    }
                }
            };
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
        }

        public void updateUI() {
            this.setUI(StripeButtonUI.createUI((JComponent)((Object)this)));
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        }

        public void paint(@NotNull Graphics graphics) {
            if (graphics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton", "paint"));
            }
            if (this.isDragging()) {
                return;
            }
            if (!this.myToolWindow.isLeft()) {
                super.paint(graphics);
                return;
            }
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(JBUI.scale((int)1), 0);
                super.paint(graphics2);
            }
            finally {
                graphics2.dispose();
            }
        }

        public int getMnemonic2() {
            return 0;
        }

        public ToolWindowAnchor getAnchor() {
            return this.myToolWindow.isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
        }

        private boolean isDragging() {
            return this.myDragImage != null;
        }

        private void handleDragging(@NotNull MouseEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton", "handleDragging"));
            }
            if (!this.isDragging()) {
                this.startDragging(event);
            }
            this.myToolWindow.fireButtonDragged(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
        }

        private void stopDragging(@NotNull MouseEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton", "stopDragging"));
            }
            if (this.isDragging()) {
                this.myToolWindow.fireButtonDropped(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
                this.myDragImage = null;
                this.myStartDragPosition = null;
            }
        }

        private void startDragging(@NotNull MouseEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton", "startDragging"));
            }
            BufferedImage image = UIUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)2);
            Graphics graphics = image.getGraphics();
            this.paint(graphics);
            graphics.dispose();
            this.myDragImage = new JBLabel((Icon)new JBImageIcon((Image)image));
            this.myStartDragPosition = event.getPoint();
        }
    }

    static interface ButtonDragListener<T> {
        public void buttonDragged(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);

        public void buttonDropped(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);
    }

    static class DragEvent {
        private final MouseEvent myMouseEvent;
        private final Component myDragImage;
        private final Point myDragPoint;

        public DragEvent(@NotNull MouseEvent mouseEvent, @NotNull Component dragImage, @NotNull Point dragPoint) {
            if (mouseEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseEvent", "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent", "<init>"));
            }
            if (dragImage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dragImage", "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent", "<init>"));
            }
            if (dragPoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dragPoint", "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent", "<init>"));
            }
            this.myMouseEvent = mouseEvent;
            this.myDragImage = dragImage;
            this.myDragPoint = dragPoint;
        }

        @NotNull
        public Point getMousePoint() {
            Point point = this.myMouseEvent.getPoint();
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent", "getMousePoint"));
            }
            return point;
        }

        @NotNull
        public Component getDragImage() {
            Component component = this.myDragImage;
            if (component == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent", "getDragImage"));
            }
            return component;
        }

        @NotNull
        public Point getDragPoint() {
            Point point = this.myDragPoint;
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent", "getDragPoint"));
            }
            return point;
        }
    }

    static enum PropertyType {
        AUTO_HIDE,
        MINIMIZED,
        LEFT,
        SPLIT,
        FLOATING;

    }
}

