/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.model.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassConverter
extends ResolvingConverter<PsiClass>
implements CustomReferenceConverter {
    @Nullable
    protected String getDefaultPackageName(ConvertContext context) {
        return null;
    }

    @Nullable
    protected String getBaseClassName(ConvertContext context) {
        return null;
    }

    @NotNull
    protected GlobalSearchScope getResolveSearchScope(ConvertContext context) {
        GlobalSearchScope scope = context.getSearchScope();
        if (scope != null) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/PsiClassConverter", "getResolveSearchScope"));
            }
            return globalSearchScope;
        }
        Module module = context.getModule();
        if (module != null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/PsiClassConverter", "getResolveSearchScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)context.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/PsiClassConverter", "getResolveSearchScope"));
        }
        return globalSearchScope;
    }

    public PsiClass fromString(String s, ConvertContext context) {
        String fullClassName = PsiClassConverter.getQualifiedClassName(s, this.getDefaultPackageName(context));
        PsiClass result = null;
        if (fullClassName != null) {
            result = DomJavaUtil.findClass((String)fullClassName, (PsiFile)context.getFile(), (Module)context.getModule(), (GlobalSearchScope)this.getResolveSearchScope(context));
            if (result == null && !Comparing.equal((String)s, (String)fullClassName)) {
                result = DomJavaUtil.findClass((String)s, (PsiFile)context.getFile(), (Module)context.getModule(), (GlobalSearchScope)this.getResolveSearchScope(context));
            }
            if (result != null && !Comparing.equal((String)this.getQualifiedName(result), (String)fullClassName)) {
                return null;
            }
        }
        return result;
    }

    @Nullable
    public static String getQualifiedClassName(String s, String defaultPackage) {
        if (s == null) {
            return null;
        }
        return StringUtil.isEmpty((String)defaultPackage) || s.indexOf(46) > -1 ? s : defaultPackage + s;
    }

    public String toString(PsiClass t, ConvertContext context) {
        if (t == null) {
            return null;
        }
        return this.processQualifiedName(this.getQualifiedName(t), context);
    }

    protected String getQualifiedName(PsiClass t) {
        return this.isJVMFormat() ? ClassUtil.getJVMClassName((PsiClass)t) : t.getQualifiedName();
    }

    protected boolean isJVMFormat() {
        return true;
    }

    private String processQualifiedName(String qualifiedName, ConvertContext context) {
        String defaultPackage = this.getDefaultPackageName(context);
        if (StringUtil.isNotEmpty((String)defaultPackage) && StringUtil.startsWithConcatenation((String)qualifiedName, (String[])new String[]{defaultPackage, ""})) {
            return qualifiedName.substring(defaultPackage.length() + 1);
        }
        return qualifiedName;
    }

    @NotNull
    public Collection<? extends PsiClass> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/PsiClassConverter", "getVariants"));
        }
        return list;
    }

    public void handleElementRename(GenericDomValue<PsiClass> genericValue, ConvertContext context, String newElementName) {
        String fqName;
        PsiClass psiClass = (PsiClass)genericValue.getValue();
        if (psiClass != null && StringUtil.isNotEmpty((String)(fqName = psiClass.getQualifiedName()))) {
            genericValue.setStringValue(this.processQualifiedName(newElementName, context));
            return;
        }
        super.handleElementRename(genericValue, context, newElementName);
    }

    public void bindReference(GenericDomValue<PsiClass> genericValue, ConvertContext context, PsiElement newTarget) {
        if (newTarget == null || newTarget instanceof PsiClass) {
            genericValue.setStringValue(this.toString((PsiClass)newTarget, context));
        } else {
            super.bindReference(genericValue, context, newTarget);
        }
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        String defaultPackage = this.getDefaultPackageName(context);
        return PsiClassConverter.getCreateClassQuickFixes(context, defaultPackage);
    }

    public static LocalQuickFix[] getCreateClassQuickFixes(ConvertContext context, String defaultPackage) {
        LocalQuickFix[] localQuickFixArray;
        IntentionAction quickFix;
        XmlFile classContext = context.getFile();
        String stringValue = ((GenericDomValue)context.getInvocationElement()).getStringValue();
        PsiNameHelper helper = PsiNameHelper.getInstance((Project)context.getPsiManager().getProject());
        IntentionAction intentionAction = quickFix = !helper.isIdentifier(stringValue) && !helper.isQualifiedName(stringValue) ? null : QuickFixFactory.getInstance().createCreateClassOrPackageFix((PsiElement)classContext, PsiClassConverter.getQualifiedClassName(stringValue, defaultPackage), true, null);
        if (quickFix instanceof LocalQuickFix) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = (LocalQuickFix)quickFix;
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        return localQuickFixArray;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/PsiClassConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        ContainerUtil.addAll(result, (Object[])this.createJavaClassReferences(element, context));
        PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/PsiClassConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    protected PsiReference[] createJavaClassReferences(PsiElement element, ConvertContext context) {
        JavaClassReferenceProvider classReferenceProvider = new JavaClassReferenceProvider();
        this.setJavaClassReferenceProviderOptions(classReferenceProvider, context);
        classReferenceProvider.setSoft(true);
        return classReferenceProvider.getReferencesByElement(element);
    }

    protected void setJavaClassReferenceProviderOptions(JavaClassReferenceProvider referenceProvider, ConvertContext context) {
        String packageName = this.getDefaultPackageName(context);
        String baseClassName = this.getBaseClassName(context);
        boolean hasDefPackage = StringUtil.isNotEmpty((String)packageName);
        if (!StringUtil.isEmpty((String)baseClassName)) {
            referenceProvider.setOption(JavaClassReferenceProvider.EXTEND_CLASS_NAMES, (Object)new String[]{baseClassName});
        }
        if (hasDefPackage) {
            referenceProvider.setOption(JavaClassReferenceProvider.DEFAULT_PACKAGE, (Object)packageName);
        }
        if (this.isJVMFormat()) {
            referenceProvider.setOption(JavaClassReferenceProvider.JVM_FORMAT, (Object)Boolean.TRUE);
        }
    }

    protected GenericDomValueReference createDomReference(GenericDomValue genericDomValue) {
        return new GenericDomValueReference(genericDomValue);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.class", (Object[])new Object[]{s});
    }
}

