/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.jsp.JspBundle;
import com.intellij.jsp.impl.CustomTagDescriptorBaseImpl;
import com.intellij.jsp.impl.CustomTagSupportUtil;
import com.intellij.jsp.impl.JspElementDescriptorEx;
import com.intellij.jsp.impl.MyTEI;
import com.intellij.jsp.impl.TldAttributeDescriptorImpl;
import com.intellij.jsp.impl.TldTagDescriptor;
import com.intellij.jsp.impl.UserClassLoader;
import com.intellij.openapi.module.Module;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.JspImplUtil;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.servlet.jsp.tagext.VariableInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TldTagDescriptorImpl
extends CustomTagDescriptorBaseImpl
implements TldTagDescriptor,
JspElementDescriptorEx {
    private String myTagClass;
    private String myTeiClass;
    private static final VariableInfo[] EMPTY_VARIABLE_INFOS = new VariableInfo[0];
    private static final ValidationMessage[] EMPTY_VALIDATION_MESSAGES = new ValidationMessage[0];
    private boolean myJsfComponentSet;
    private boolean myJsfComponent;

    public TldTagDescriptorImpl() {
    }

    public TldTagDescriptorImpl(XmlTag tag) {
        this.init((PsiElement)tag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context) {
        return (XmlAttributeDescriptor[])myAttributeDescriptorsCache.get((Object)this);
    }

    @Override
    protected final XmlAttributeDescriptor[] doCalculateAttributes() {
        XmlTag[] subTags = this.myTag.findSubTags("attribute");
        XmlAttributeDescriptor[] xmlAttributeDescriptors = new XmlAttributeDescriptor[subTags.length];
        for (int i = 0; i < subTags.length; ++i) {
            xmlAttributeDescriptors[i] = new TldAttributeDescriptorImpl(subTags[i], CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR);
        }
        return xmlAttributeDescriptors;
    }

    @Nullable
    public String getName() {
        if (this.myName == null) {
            XmlTag firstSubTag = this.myTag.findFirstSubTag("name");
            this.myName = firstSubTag != null ? firstSubTag.getValue().getTrimmedText() : null;
        }
        return this.myName;
    }

    public void init(PsiElement element) {
        XmlTag tei;
        if (this.myTag != element && this.myTag != null) {
            this.myNsDescriptor = null;
        }
        this.myTag = (XmlTag)element;
        XmlTag bodyContent = this.myTag.findFirstSubTag("bodycontent");
        if (bodyContent == null) {
            bodyContent = this.myTag.findFirstSubTag("body-content");
        }
        if (bodyContent != null) {
            this.myContentType = this.getContentType(bodyContent.getValue().getTrimmedText());
        }
        if ((tei = this.myTag.findFirstSubTag("teiclass")) == null) {
            tei = this.myTag.findFirstSubTag("tei-class");
        }
        this.myTeiClass = tei != null ? tei.getValue().getTrimmedText() : null;
        tei = this.myTag.findFirstSubTag("tagclass");
        if (tei == null) {
            tei = this.myTag.findFirstSubTag("tag-class");
        }
        this.myTagClass = tei != null ? tei.getValue().getTrimmedText() : null;
        XmlTag dynamicAttributes = this.myTag.findFirstSubTag("dynamic-attributes");
        if (dynamicAttributes != null) {
            this.myDynamicAttributes = CustomTagSupportUtil.isTrue(dynamicAttributes.getValue().getTrimmedText());
        }
        XmlTag[] vars = this.myTag.findSubTags("variable");
        CustomTagSupportUtil.configureVariables(this.myTLDVars, vars, CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR);
        XmlTag[] attributes = this.myTag.findSubTags("attribute");
        CustomTagSupportUtil.configureAttributes(this.myTLDAttributes, attributes, CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR);
    }

    @NotNull
    public Object[] getDependences() {
        Object[] objectArray = new Object[]{this.myTag, ExternalResourceManager.getInstance()};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/impl/TldTagDescriptorImpl", "getDependences"));
        }
        return objectArray;
    }

    @Override
    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsp/impl/TldTagDescriptorImpl", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/jsp/impl/TldTagDescriptorImpl", "validate"));
        }
        super.validate(context, host);
        PsiFile containingFile = context.getContainingFile();
        if (!JspPsiUtil.isInJspFile((PsiElement)containingFile)) {
            return;
        }
        TagExtraInfo info = this.getExtraInfo(JspUtil.getModuleForPsiElement((PsiElement)containingFile));
        if (info != null) {
            try {
                ValidationMessage[] messages = info.validate(JspImplUtil.getTagData(context));
                if (messages != null && messages.length > 0) {
                    for (ValidationMessage message : messages) {
                        host.addMessage((PsiElement)context, JspBundle.message("wrong.tag.data.error.message", message.getMessage()), Validator.ValidationHost.ErrorType.ERROR);
                    }
                }
            }
            catch (Throwable e) {
                host.addMessage((PsiElement)context, JspBundle.message("exception.during.tei.processing.occured.with.error.error.message", e.getMessage()), Validator.ValidationHost.ErrorType.ERROR);
            }
        }
    }

    @Nullable
    private TagExtraInfo getAndCacheExtraInfo(Module module) {
        try {
            Class aClass = UserClassLoader.loadClass(this.myTeiClass, module, (PsiFile)this.getNSDescriptor().getDescriptorFile());
            if (aClass != null) {
                Object tei = aClass.newInstance();
                TagExtraInfo tagExtraInfo = (TagExtraInfo)tei;
                return new MyTagExtraInfo(tagExtraInfo);
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public TagExtraInfo getExtraInfo(Module module) {
        TagExtraInfo castedTei = null;
        if (this.myTeiClass != null) {
            try {
                castedTei = this.getAndCacheExtraInfo(module);
                if (castedTei != null) {
                    castedTei.setTagInfo(new TagInfo(this.myName, this.myTagClass, "", "", new TagLibraryInfo("", ""){}, castedTei, this.myTLDAttributes.toArray(new TagAttributeInfo[this.myTLDAttributes.size()]), this.myName, "", "", this.myTLDVars.toArray(new TagVariableInfo[this.myTLDVars.size()])));
                }
            }
            catch (Throwable t) {
                castedTei = null;
            }
        }
        if (castedTei != null) {
            return castedTei;
        }
        return new MyTEI(this.myTLDVars, this);
    }

    @Override
    public XmlTag findVariableWithName(String name) {
        return this.findVariableWithName(this.myTag.findSubTags("variable"), name, CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR);
    }

    public PsiElement getDeclaration() {
        return this.myTag;
    }

    public String getTagClass() {
        return this.myTagClass;
    }

    public String getTeiClass() {
        return this.myTeiClass;
    }

    @Override
    public void resetClassloaderState() {
        this.myJsfComponentSet = false;
    }

    public boolean isJsfComponent(Module module) {
        if (!this.myJsfComponentSet) {
            this.myJsfComponent = false;
            if (this.myTagClass != null) {
                try {
                    Class aClass = UserClassLoader.loadClass(this.myTagClass, module);
                    if (aClass != null) {
                        Class jsfUIComponentClass = UserClassLoader.loadClass("javax.faces.webapp.UIComponentTag", module);
                        if (jsfUIComponentClass != null && jsfUIComponentClass.isAssignableFrom(aClass)) {
                            this.myJsfComponent = true;
                            return true;
                        }
                        jsfUIComponentClass = UserClassLoader.loadClass("javax.faces.webapp.UIComponentTagBase", module);
                        if (jsfUIComponentClass != null && jsfUIComponentClass.isAssignableFrom(aClass)) {
                            this.myJsfComponent = true;
                            return true;
                        }
                    }
                }
                catch (Throwable t) {
                    this.myJsfComponent = false;
                }
            }
            this.myJsfComponentSet = true;
        }
        return this.myJsfComponent;
    }

    private static class MyTagExtraInfo
    extends TagExtraInfo {
        private final TagExtraInfo myTagExtraInfo;

        public MyTagExtraInfo(TagExtraInfo tagExtraInfo) {
            this.myTagExtraInfo = tagExtraInfo;
        }

        public VariableInfo[] getVariableInfo(TagData tagData) {
            try {
                this.myTagExtraInfo.setTagInfo(this.getTagInfo());
                return this.myTagExtraInfo.getVariableInfo(tagData);
            }
            catch (Throwable t) {
                return EMPTY_VARIABLE_INFOS;
            }
        }

        public boolean isValid(TagData tagData) {
            try {
                this.myTagExtraInfo.setTagInfo(this.getTagInfo());
                return this.myTagExtraInfo.isValid(tagData);
            }
            catch (Throwable t) {
                return false;
            }
        }

        public ValidationMessage[] validate(TagData tagData) {
            try {
                this.myTagExtraInfo.setTagInfo(this.getTagInfo());
                return this.myTagExtraInfo.validate(tagData);
            }
            catch (Throwable t) {
                return EMPTY_VALIDATION_MESSAGES;
            }
        }
    }
}

