/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.index;

import com.intellij.jsp.index.JspDirectiveProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("jsp" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/index/JspIncludeProvider", "getId"));
        }
        return "jsp";
    }

    public boolean acceptFile(VirtualFile file) {
        FileType fileType = file.getFileType();
        return fileType == StdFileTypes.JSP || fileType == StdFileTypes.JSPX || fileType == StdFileTypes.XHTML;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/jsp/index/JspIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)StdFileTypes.JSP);
        fileTypeSink.consume((Object)StdFileTypes.JSPX);
        fileTypeSink.consume((Object)StdFileTypes.XHTML);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        Project project = content.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        final ArrayList list = new ArrayList();
        new JspDirectiveProcessor(psiManager, !content.getFileType().equals(StdFileTypes.JSP)){

            @Override
            public void processDirective(XmlTag directive, JspDirectiveKind directiveKind, int offset) {
                String value;
                if (directive.getName().endsWith("include") && (value = directive.getAttributeValue("file")) != null) {
                    list.add(new FileIncludeInfo(value, offset));
                }
            }
        }.processDirectives(content.getContentAsText());
        FileIncludeInfo[] fileIncludeInfoArray = list.toArray(new FileIncludeInfo[list.size()]);
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/index/JspIncludeProvider", "getIncludeInfos"));
        }
        return fileIncludeInfoArray;
    }

    @Nullable
    public PsiFileSystemItem resolveIncludedFile(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/jsp/index/JspIncludeProvider", "resolveIncludedFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsp/index/JspIncludeProvider", "resolveIncludedFile"));
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)context.getProject());
        PsiFileImpl psiFile = (PsiFileImpl)factory.createFileFromText("dummy.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)info.path);
        psiFile.setOriginalFile(context);
        FileReferenceSet referenceSet = new FileReferenceSet((PsiElement)psiFile){

            protected boolean useIncludingFileAsContext() {
                return false;
            }
        };
        return JspUtil.resolveReferenceSet(referenceSet, context);
    }

    public int getVersion() {
        return 1;
    }
}

