/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlSchemaProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspSchemaProvider
extends XmlSchemaProvider {
    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/psi/impl/source/jsp/JspSchemaProvider", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/psi/impl/source/jsp/JspSchemaProvider", "getSchema"));
        }
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)baseFile);
        if (jspFile != null) {
            return JspManager.getInstance((Project)baseFile.getProject()).getTldFileByUri(url, module, jspFile);
        }
        return null;
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspSchemaProvider", "isAvailable"));
        }
        return file.getViewProvider() instanceof JspxFileViewProvider;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, String tagName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspSchemaProvider", "getAvailableNamespaces"));
        }
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        String[] uris = JspManager.getInstance((Project)file.getProject()).getPossibleTldUris(jspFile);
        HashSet<String> set = new HashSet<String>(Arrays.asList(uris));
        set.add("urn:jsptagdir:/WEB-INF/tags");
        Set set2 = DefaultXmlExtension.filterNamespaces(set, (String)tagName, (XmlFile)file);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspSchemaProvider", "getAvailableNamespaces"));
        }
        return set2;
    }

    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/psi/impl/source/jsp/JspSchemaProvider", "getDefaultPrefix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspSchemaProvider", "getDefaultPrefix"));
        }
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)context);
        String prefix = JspManager.getInstance((Project)context.getProject()).getPrefixForNamespace(namespace, jspFile);
        return prefix == null ? null : prefix.toLowerCase();
    }
}

