/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenPropertyPsiReference;
import org.jetbrains.idea.maven.dom.references.MavenPsiElementWrapper;

public class MavenPropertyInParentInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = MavenDomBundle.message("inspection.property.in.parent.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("MavenPropertyInParent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection", "getShortName"));
        }
        return "MavenPropertyInParent";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        DomManager domManager;
        DomFileElement model;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection", "checkFile"));
        }
        if (file instanceof XmlFile && (file.isPhysical() || ApplicationManager.getApplication().isUnitTestMode()) && (model = (domManager = DomManager.getDomManager((Project)file.getProject())).getFileElement((XmlFile)file, MavenDomProjectModel.class)) != null) {
            ArrayList problems = ContainerUtil.newArrayListWithCapacity((int)3);
            MavenDomParent mavenParent = ((MavenDomProjectModel)model.getRootElement()).getMavenParent();
            MavenPropertyInParentInspection.validate(manager, isOnTheFly, problems, (GenericDomValue<String>)mavenParent.getGroupId());
            MavenPropertyInParentInspection.validate(manager, isOnTheFly, problems, (GenericDomValue<String>)mavenParent.getArtifactId());
            MavenPropertyInParentInspection.validate(manager, isOnTheFly, problems, (GenericDomValue<String>)mavenParent.getVersion());
            if (problems.isEmpty()) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            return problems.toArray(new ProblemDescriptor[problems.size()]);
        }
        return null;
    }

    private static void validate(@NotNull InspectionManager manager, boolean isOnTheFly, @NotNull List<ProblemDescriptor> problems, @NotNull GenericDomValue<String> domValue) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection", "validate"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection", "validate"));
        }
        if (domValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domValue", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection", "validate"));
        }
        String unresolvedValue = domValue.getRawText();
        if (unresolvedValue != null && unresolvedValue.contains("${")) {
            LocalQuickFixBase fix = null;
            String resolvedValue = domValue.getStringValue();
            if (unresolvedValue.equals(resolvedValue)) {
                resolvedValue = MavenPropertyInParentInspection.resolveXmlElement(domValue.getXmlElement());
            }
            if (!unresolvedValue.equals(resolvedValue) && !StringUtil.isEmpty((String)resolvedValue)) {
                final String finalResolvedValue = resolvedValue;
                fix = new LocalQuickFixBase(MavenDomBundle.message("refactoring.inline.property", new Object[0])){

                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection$1", "applyFix"));
                        }
                        if (descriptor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection$1", "applyFix"));
                        }
                        ((XmlTag)descriptor.getPsiElement()).getValue().setText(finalResolvedValue);
                    }
                };
            }
            problems.add(manager.createProblemDescriptor((PsiElement)domValue.getXmlTag(), MavenDomBundle.message("inspection.property.in.parent.description", new Object[0]), fix, ProblemHighlightType.GENERIC_ERROR, isOnTheFly));
        }
    }

    @Nullable
    private static String resolveXmlElement(@Nullable XmlElement xmlElement) {
        if (xmlElement == null) {
            return null;
        }
        MavenPropertyPsiReference psiReference = (MavenPropertyPsiReference)ContainerUtil.findInstance((Object[])xmlElement.getReferences(), MavenPropertyPsiReference.class);
        if (psiReference == null) {
            return null;
        }
        PsiElement resolvedElement = psiReference.resolve();
        if (resolvedElement == null || !(resolvedElement instanceof MavenPsiElementWrapper)) {
            return null;
        }
        PsiElement xmlTag = ((MavenPsiElementWrapper)resolvedElement).getWrappee();
        if (!(xmlTag instanceof XmlTag)) {
            return null;
        }
        return ((XmlTag)xmlTag).getValue().getTrimmedText();
    }
}

