/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.testing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringTestingWebContextProvider
extends SpringTestingImplicitContextsProvider {
    @NotNull
    public Collection<CommonSpringModel> getModels(final Module module, @NotNull ContextConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/web/testing/SpringTestingWebContextProvider", "getModels"));
        }
        List models = ContainerUtil.newSmartList();
        final GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true);
        if (SpringTestingWebContextProvider.isAnnotated((ContextConfiguration)configuration, (Module)module, (String)"org.springframework.test.context.web.WebAppConfiguration")) {
            models.add(new BeansSpringModel(module, (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    List pointers = ContainerUtil.newSmartList();
                    ContainerUtil.addIfNotNull((Collection)pointers, (Object)this.createMockBean("mockServletContext", "org.springframework.mock.web.MockServletContext"));
                    ContainerUtil.addIfNotNull((Collection)pointers, (Object)this.createMockBean("mockHttpSession", "org.springframework.mock.web.MockHttpSession"));
                    ContainerUtil.addIfNotNull((Collection)pointers, (Object)this.createMockBean("mockHttpServletRequest", "org.springframework.mock.web.MockHttpServletRequest"));
                    List list = pointers;
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/testing/SpringTestingWebContextProvider$1", "compute"));
                    }
                    return list;
                }

                @Nullable
                private SpringBeanPointer createMockBean(@NotNull String beanName, @NotNull String beanClass) {
                    if (beanName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/web/testing/SpringTestingWebContextProvider$1", "createMockBean"));
                    }
                    if (beanClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/web/testing/SpringTestingWebContextProvider$1", "createMockBean"));
                    }
                    SpringImplicitBean bean = SpringImplicitBean.create((String)"MVC Testing Beans", (PsiClass)JavaPsiFacade.getInstance((Project)module.getProject()).findClass(beanClass, searchScope), (String)beanName);
                    return bean != null ? BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean) : null;
                }
            }));
        }
        List list = models;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/testing/SpringTestingWebContextProvider", "getModels"));
        }
        return list;
    }
}

