/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;

public class AppCompatResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("AppCompatResource", "Menu namespace", "When using the appcompat library, menu resources should refer to the `showAsAction` in the `app:` namespace, not the `android:` namespace.\n\nSimilarly, when *not* using the appcompat library, you should be using the `android:showAsAction` attribute.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(AppCompatResourceDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("showAsAction");
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        Project mainProject = context.getMainProject();
        if (mainProject.isGradleProject()) {
            Boolean appCompat = mainProject.dependsOn("com.android.support:appcompat-v7");
            if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
                if (context.getFolderVersion() >= 14) {
                    return;
                }
                if (appCompat == Boolean.TRUE) {
                    context.report(ISSUE, attribute, context.getLocation(attribute), "Should use `app:showAsAction` with the appcompat library with `xmlns:app=\"http://schemas.android.com/apk/res-auto\"`");
                }
            } else if (appCompat == Boolean.FALSE) {
                context.report(ISSUE, attribute, context.getLocation(attribute), "Should use `android:showAsAction` when not using the appcompat library");
            }
        }
    }
}

