/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LocaleDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LocaleDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue STRING_LOCALE = Issue.create("DefaultLocale", "Implied default locale in case conversion", "Calling `String#toLowerCase()` or `#toUpperCase()` *without specifying an explicit locale* is a common source of bugs. The reason for that is that those methods will use the current locale on the user's device, and even though the code appears to work correctly when you are developing the app, it will fail in some locales. For example, in the Turkish locale, the uppercase replacement for `i` is *not* `I`.\n\nIf you want the methods to just perform ASCII replacement, for example to convert an enum name, call `String#toUpperCase(Locale.US)` instead. If you really want to use the current locale, call `String#toUpperCase(Locale.getDefault())` instead.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/java/util/Locale.html#default_locale");

    @Override
    public List<String> getApplicableMethodNames() {
        if (LintClient.isStudio()) {
            return Collections.singletonList("format");
        }
        return Arrays.asList("toLowerCase", "toUpperCase", "format");
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        if (context.getEvaluator().isMemberInClass((PsiMember)method, "java.lang.String")) {
            String name = method.getName();
            if (name.equals("format")) {
                LocaleDetector.checkFormat(context, method, call);
            } else if (method.getParameterList().getParametersCount() == 0) {
                Location location = context.getNameLocation((PsiElement)call);
                String message = String.format("Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead. For strings meant to be internal use `Locale.ROOT`, otherwise `Locale.getDefault()`.", name);
                context.report(STRING_LOCALE, (PsiElement)call, location, message);
            }
        }
    }

    private static boolean isLoggingParameter(JavaContext context, PsiMethodCallExpression node) {
        String name;
        PsiMethodCallExpression parentCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PsiMethodCallExpression.class, (boolean)true);
        if (parentCall != null && (name = parentCall.getMethodExpression().getReferenceName()) != null && name.length() == 1) {
            PsiMethod method = parentCall.resolveMethod();
            return context.getEvaluator().isMemberInClass((PsiMember)method, "android.util.Log");
        }
        return false;
    }

    private static void checkFormat(JavaContext context, PsiMethod method, PsiMethodCallExpression call) {
        if (method.getParameterList().getParametersCount() == 0 || !context.getEvaluator().parameterHasType(method, 0, "java.lang.String")) {
            return;
        }
        PsiExpression[] expressions = call.getArgumentList().getExpressions();
        if (expressions.length == 0) {
            return;
        }
        PsiExpression first = expressions[0];
        Object value = ConstantEvaluator.evaluate(context, (PsiElement)first);
        if (!(value instanceof String)) {
            return;
        }
        String format = (String)value;
        if (StringFormatDetector.isLocaleSpecific(format)) {
            if (LocaleDetector.isLoggingParameter(context, call)) {
                return;
            }
            Location location = context.getLocation((PsiElement)call);
            String message = "Implicitly using the default locale is a common source of bugs: Use `String.format(Locale, ...)` instead";
            context.report(STRING_LOCALE, (PsiElement)call, location, message);
        }
    }
}

