/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

class OtherFileVisitor {
    private final List<Detector> detectors;
    private final Map<Scope, List<File>> files = new EnumMap<Scope, List<File>>(Scope.class);

    OtherFileVisitor(List<Detector> detectors) {
        this.detectors = detectors;
    }

    void scan(LintDriver driver, Project project, Project main) {
        ArrayList<File> files;
        File projectFolder = project.getDir();
        EnumSet<Scope> scopes = EnumSet.noneOf(Scope.class);
        for (Detector detector : this.detectors) {
            Detector.OtherFileScanner fileScanner = (Detector.OtherFileScanner)((Object)detector);
            EnumSet<Scope> applicable = fileScanner.getApplicableFiles();
            if (applicable.contains((Object)Scope.OTHER)) {
                scopes = Scope.ALL;
                break;
            }
            scopes.addAll(applicable);
        }
        List<File> subset = project.getSubset();
        if (scopes.contains((Object)Scope.RESOURCE_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                for (File file : subset) {
                    if (!SdkUtils.endsWith((CharSequence)file.getPath(), (CharSequence)".xml") || file.getName().equals("AndroidManifest.xml")) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    this.files.put(Scope.RESOURCE_FILE, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File res : project.getResourceFolders()) {
                    OtherFileVisitor.collectFiles(files, res);
                }
                File assets = new File(projectFolder, "assets");
                if (assets.exists()) {
                    OtherFileVisitor.collectFiles(files, assets);
                }
                if (!files.isEmpty()) {
                    this.files.put(Scope.RESOURCE_FILE, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.JAVA_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                for (File file : subset) {
                    if (!file.getPath().endsWith(".java")) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    this.files.put(Scope.JAVA_FILE, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File srcFolder : project.getJavaSourceFolders()) {
                    OtherFileVisitor.collectFiles(files, srcFolder);
                }
                if (!files.isEmpty()) {
                    this.files.put(Scope.JAVA_FILE, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.CLASS_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    if (!file.getPath().endsWith(".class")) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    this.files.put(Scope.CLASS_FILE, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File classFolder : project.getJavaClassFolders()) {
                    OtherFileVisitor.collectFiles(files, classFolder);
                }
                if (!files.isEmpty()) {
                    this.files.put(Scope.CLASS_FILE, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.MANIFEST)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    if (!file.getName().equals("AndroidManifest.xml")) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    this.files.put(Scope.MANIFEST, files);
                }
            } else {
                List<File> manifestFiles = project.getManifestFiles();
                if (manifestFiles != null) {
                    this.files.put(Scope.MANIFEST, manifestFiles);
                }
            }
        }
        for (Map.Entry<Scope, List<File>> entry : this.files.entrySet()) {
            Scope scope = entry.getKey();
            List<File> files2 = entry.getValue();
            ArrayList<Detector> applicable = new ArrayList<Detector>(this.detectors.size());
            for (Detector detector : this.detectors) {
                Detector.OtherFileScanner fileScanner = (Detector.OtherFileScanner)((Object)detector);
                EnumSet<Scope> appliesTo = fileScanner.getApplicableFiles();
                if (!appliesTo.contains((Object)Scope.OTHER) && !appliesTo.contains((Object)scope)) continue;
                applicable.add(detector);
            }
            if (applicable.isEmpty()) continue;
            for (File file : files2) {
                Context context = new Context(driver, project, main, file);
                for (Detector detector : applicable) {
                    detector.beforeCheckFile(context);
                    detector.run(context);
                    detector.afterCheckFile(context);
                }
                if (!driver.isCanceled()) continue;
                return;
            }
        }
    }

    private static void collectFiles(List<File> files, File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    OtherFileVisitor.collectFiles(files, child);
                }
            }
        } else {
            files.add(file);
        }
    }
}

