/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestElementPath {
    private final List<String> mySuiteNames;
    private final String myTestName;
    private final JSCallExpression myTestElement;

    public JsTestElementPath(@NotNull List<String> suiteNames, @Nullable String testName, @NotNull JSCallExpression testElement) {
        if (suiteNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteNames", "com/intellij/javascript/testFramework/JsTestElementPath", "<init>"));
        }
        if (testElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testElement", "com/intellij/javascript/testFramework/JsTestElementPath", "<init>"));
        }
        this.mySuiteNames = suiteNames;
        this.myTestName = testName;
        this.myTestElement = testElement;
    }

    @NotNull
    public List<String> getSuiteNames() {
        List<String> list = this.mySuiteNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestElementPath", "getSuiteNames"));
        }
        return list;
    }

    @NotNull
    public List<String> getAllNames() {
        ArrayList names = ContainerUtil.newArrayList(this.mySuiteNames);
        names.add(this.myTestName);
        ArrayList arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestElementPath", "getAllNames"));
        }
        return arrayList;
    }

    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    @NotNull
    public JSCallExpression getTestElement() {
        JSCallExpression jSCallExpression = this.myTestElement;
        if (jSCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestElementPath", "getTestElement"));
        }
        return jSCallExpression;
    }
}

