/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.html.include;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class HtmlFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("html" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/html/include/HtmlFileIncludeProvider", "getId"));
        }
        return "html";
    }

    public boolean acceptFile(VirtualFile file) {
        return HtmlUtil.isHtmlFile((VirtualFile)file);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/htmltools/html/include/HtmlFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)StdFileTypes.HTML);
        fileTypeSink.consume((Object)StdFileTypes.XHTML);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        PsiFile psiFile = content.getPsiFile();
        if (psiFile instanceof XmlFile) {
            FileIncludeInfo[] fileIncludeInfoArray = HtmlFileIncludeProvider.getIncludeInfos((XmlFile)psiFile);
            if (fileIncludeInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/html/include/HtmlFileIncludeProvider", "getIncludeInfos"));
            }
            return fileIncludeInfoArray;
        }
        if (FileIncludeInfo.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/html/include/HtmlFileIncludeProvider", "getIncludeInfos"));
        }
        return FileIncludeInfo.EMPTY;
    }

    public static FileIncludeInfo[] getIncludeInfos(XmlFile xmlFile) {
        return (FileIncludeInfo[])HtmlUtil.getIncludedPathsElements((XmlFile)xmlFile).stream().filter(el -> el != null && !StringUtil.isEmptyOrSpaces((String)el.getValue())).map(el -> new FileIncludeInfo(el.getValue())).toArray(FileIncludeInfo[]::new);
    }
}

