/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.jest.JestRunConfigurationEditor;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestRunState;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.InetSocketAddress;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration,
PreferableRunConfiguration {
    private JestRunSettings mySettings;

    protected JestRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestRunConfiguration", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/javascript/jest/JestRunConfiguration", "<init>"));
        }
        super(project, factory, name);
        this.mySettings = JestRunSettings.builder().build();
    }

    @NotNull
    public JestRunSettings getRunSettings() {
        JestRunSettings jestRunSettings = this.mySettings;
        if (jestRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfiguration", "getRunSettings"));
        }
        return jestRunSettings;
    }

    public void setRunSettings(@NotNull JestRunSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/jest/JestRunConfiguration", "setRunSettings"));
        }
        this.mySettings = settings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        JestRunConfigurationEditor jestRunConfigurationEditor = new JestRunConfigurationEditor(this.getProject());
        if (jestRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfiguration", "getConfigurationEditor"));
        }
        return jestRunConfigurationEditor;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.mySettings = JestUtil.readXml(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JestUtil.writeXml(element, this.mySettings);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JestUtil.checkRunConfiguration(this);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/jest/JestRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/jest/JestRunConfiguration", "getState"));
        }
        NodePackage pkg = this.getJestPackage();
        return new JestRunState(this, environment, pkg);
    }

    @NotNull
    public NodePackage getJestPackage() {
        Project project = this.getProject();
        NodeJsInterpreter interpreter = this.mySettings.getInterpreterRef().resolve(project);
        NodePackage nodePackage = JestUtil.getJestPackage(project, interpreter);
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfiguration", "getJestPackage"));
        }
        return nodePackage;
    }

    @Nullable
    public String suggestedName() {
        JestRunSettings settings = this.mySettings;
        JestScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind == JestScopeKind.TEST_FILE) {
            return PathUtil.getFileName((String)settings.getTestFileSystemDependentPath());
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            return JsTestFqn.getPresentableName(settings.getTestNames());
        }
        if (StringUtil.isNotEmpty((String)settings.getConfigFileSystemDependentPath())) {
            return PathUtil.getFileName((String)settings.getConfigFileSystemDependentPath());
        }
        return "All Tests";
    }

    @Nullable
    public String getActionName() {
        JestScopeKind scopeKind = this.mySettings.getScopeKind();
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            return StringUtil.notNullize((String)((String)ContainerUtil.getLastItem(this.mySettings.getTestNames())));
        }
        return super.getActionName();
    }

    @Override
    @Nullable
    public InetSocketAddress getDebugAddress() throws ExecutionException {
        return null;
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        if (otherRc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherRc", "com/intellij/javascript/jest/JestRunConfiguration", "isPreferredOver"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/javascript/jest/JestRunConfiguration", "isPreferredOver"));
        }
        return true;
    }

    public void initializeFields() {
        VirtualFile dir;
        if (this.mySettings.getWorkingDirSystemDependentPath().trim().isEmpty() && (dir = this.getProject().getBaseDir()) != null) {
            this.mySettings = this.mySettings.toBuilder().setWorkingDir(dir.getPath()).build();
        }
    }
}

