/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JestRunSettings {
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myConfigFilePath;
    private final String myWorkingDir;
    private final String myJestOptions;
    private final EnvironmentVariablesData myEnvData;
    private final JestScopeKind myScopeKind;
    private final String myTestFilePath;
    private final List<String> myTestNames;

    public JestRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javascript/jest/JestRunSettings", "<init>"));
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myConfigFilePath = FileUtil.toSystemDependentName((String)builder.myConfigFilePath);
        this.myWorkingDir = FileUtil.toSystemDependentName((String)builder.myWorkingDir);
        this.myJestOptions = builder.myJestOptions;
        this.myEnvData = builder.myEnvData;
        this.myScopeKind = builder.myScopeKind;
        this.myTestFilePath = FileUtil.toSystemDependentName((String)builder.myTestFilePath);
        this.myTestNames = ImmutableList.copyOf((Collection)builder.myTestNames);
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getConfigFileSystemDependentPath() {
        String string = this.myConfigFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "getConfigFileSystemDependentPath"));
        }
        return string;
    }

    @NotNull
    public String getWorkingDirSystemDependentPath() {
        String string = this.myWorkingDir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "getWorkingDirSystemDependentPath"));
        }
        return string;
    }

    @NotNull
    public String getJestOptions() {
        String string = this.myJestOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "getJestOptions"));
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "getEnvData"));
        }
        return environmentVariablesData;
    }

    @NotNull
    public JestScopeKind getScopeKind() {
        JestScopeKind jestScopeKind = this.myScopeKind;
        if (jestScopeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "getScopeKind"));
        }
        return jestScopeKind;
    }

    @NotNull
    public String getTestFileSystemDependentPath() {
        String string = this.myTestFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "getTestFileSystemDependentPath"));
        }
        return string;
    }

    @NotNull
    public List<String> getTestNames() {
        List<String> list = this.myTestNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "getTestNames"));
        }
        return list;
    }

    @NotNull
    public Builder toBuilder() {
        Builder builder = new Builder().setInterpreterRef(this.myInterpreterRef).setConfigFilePath(this.myConfigFilePath).setWorkingDir(this.myWorkingDir).setJestOptions(this.myJestOptions).setEnvData(this.myEnvData).setScopeKind(this.myScopeKind).setTestFilePath(this.myTestFilePath).setTestNames(this.myTestNames);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "toBuilder"));
        }
        return builder;
    }

    @NotNull
    public static Builder builder() {
        Builder builder = new Builder();
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings", "builder"));
        }
        return builder;
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
        private String myConfigFilePath = "";
        private String myWorkingDir = "";
        private String myJestOptions = "";
        private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;
        private JestScopeKind myScopeKind = JestScopeKind.ALL;
        private String myTestFilePath = "";
        private List<String> myTestNames = Collections.emptyList();

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/javascript/jest/JestRunSettings$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setConfigFilePath(@NotNull String configFilePath) {
            if (configFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePath", "com/intellij/javascript/jest/JestRunSettings$Builder", "setConfigFilePath"));
            }
            this.myConfigFilePath = configFilePath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings$Builder", "setConfigFilePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setWorkingDir(@NotNull String workingDir) {
            if (workingDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/javascript/jest/JestRunSettings$Builder", "setWorkingDir"));
            }
            this.myWorkingDir = workingDir;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings$Builder", "setWorkingDir"));
            }
            return builder;
        }

        @NotNull
        public Builder setJestOptions(@NotNull String jestOptions) {
            if (jestOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jestOptions", "com/intellij/javascript/jest/JestRunSettings$Builder", "setJestOptions"));
            }
            this.myJestOptions = jestOptions;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings$Builder", "setJestOptions"));
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/javascript/jest/JestRunSettings$Builder", "setEnvData"));
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings$Builder", "setEnvData"));
            }
            return builder;
        }

        @NotNull
        public Builder setScopeKind(@NotNull JestScopeKind scopeKind) {
            if (scopeKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeKind", "com/intellij/javascript/jest/JestRunSettings$Builder", "setScopeKind"));
            }
            this.myScopeKind = scopeKind;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings$Builder", "setScopeKind"));
            }
            return builder;
        }

        @NotNull
        public Builder setTestFilePath(@NotNull String testFilePath) {
            if (testFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFilePath", "com/intellij/javascript/jest/JestRunSettings$Builder", "setTestFilePath"));
            }
            this.myTestFilePath = testFilePath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings$Builder", "setTestFilePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setTestNames(@NotNull List<String> testNames) {
            if (testNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "com/intellij/javascript/jest/JestRunSettings$Builder", "setTestNames"));
            }
            this.myTestNames = testNames;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings$Builder", "setTestNames"));
            }
            return builder;
        }

        @NotNull
        public JestRunSettings build() {
            JestRunSettings jestRunSettings = new JestRunSettings(this);
            if (jestRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunSettings$Builder", "build"));
            }
            return jestRunSettings;
        }
    }
}

