/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterRef {
    public static final String PROJECT_LEVEL = "project";
    private final String myReferenceName;

    private NodeJsInterpreterRef(@NotNull String referenceName) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "<init>"));
        }
        this.myReferenceName = FileUtil.toSystemIndependentName((String)referenceName);
    }

    private NodeJsInterpreterRef(@Nullable NodeJsInterpreter interpreter) {
        this.myReferenceName = interpreter == null ? "" : interpreter.getReferenceName();
    }

    @NotNull
    public String getReferenceName() {
        String string = this.myReferenceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "getReferenceName"));
        }
        return string;
    }

    @Nullable
    public NodeJsInterpreter resolve(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROJECT_LEVEL, "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "resolve"));
        }
        if (PROJECT_LEVEL.equals(this.myReferenceName)) {
            return NodeJsInterpreterManager.getInstance(project).getDefault();
        }
        return this.resolveWithoutAliases();
    }

    @NotNull
    public NodeJsLocalInterpreter resolveAsLocal(@NotNull Project project) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROJECT_LEVEL, "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "resolveAsLocal"));
        }
        NodeJsInterpreter interpreter = this.resolve(project);
        NodeJsLocalInterpreter nodeJsLocalInterpreter = NodeJsLocalInterpreter.cast(interpreter);
        if (nodeJsLocalInterpreter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "resolveAsLocal"));
        }
        return nodeJsLocalInterpreter;
    }

    @Nullable
    public NodeJsInterpreter resolveWithoutAliases() {
        if (this.myReferenceName.isEmpty()) {
            return null;
        }
        boolean remote = NodeJsRemoteInterpreterType.getInstance().isRemoteReference(this);
        NodeJsInterpreterType type = remote ? NodeJsRemoteInterpreterType.getInstance() : NodeJsLocalInterpreterType.getInstance();
        return type.findByReferenceName(this.myReferenceName);
    }

    @NotNull
    public static NodeJsInterpreterRef createProjectRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = new NodeJsInterpreterRef(PROJECT_LEVEL);
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "createProjectRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public static NodeJsInterpreterRef create(@Nullable String referenceName) {
        NodeJsInterpreterRef nodeJsInterpreterRef = new NodeJsInterpreterRef(StringUtil.notNullize((String)referenceName, (String)PROJECT_LEVEL));
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "create"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public static NodeJsInterpreterRef create(@Nullable NodeJsInterpreter interpreter) {
        NodeJsInterpreterRef nodeJsInterpreterRef = new NodeJsInterpreterRef(interpreter);
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "create"));
        }
        return nodeJsInterpreterRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsInterpreterRef ref = (NodeJsInterpreterRef)o;
        return !(this.myReferenceName != null ? !this.myReferenceName.equals(ref.myReferenceName) : ref.myReferenceName != null);
    }

    public int hashCode() {
        return this.myReferenceName != null ? this.myReferenceName.hashCode() : 0;
    }
}

