/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.ide.IconProvider;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NodeModulesDirectoryIconProvider
extends IconProvider
implements DumbAware {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "getIcon"));
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)element;
            Project project = psiDirectory.getProject();
            VirtualFile dir = psiDirectory.getVirtualFile();
            boolean excluded = ProjectFileIndex.getInstance((Project)project).isExcluded(dir);
            if (excluded && dir.isDirectory() && NodeModulesDirectoryIconProvider.shouldShowNotExcludedIcon(project, dir)) {
                return PlatformIcons.DIRECTORY_CLOSED_ICON;
            }
        }
        return null;
    }

    private static boolean shouldShowNotExcludedIcon(@NotNull Project project, @NotNull VirtualFile dir) {
        PackageJsonData data;
        VirtualFile packageJson;
        VirtualFile nodeModulesDir;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "shouldShowNotExcludedIcon"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "shouldShowNotExcludedIcon"));
        }
        if (NodeModulesDirectoryIconProvider.isNodeModulesDirWithMappings(project, dir)) {
            return true;
        }
        return NodeModuleSearchUtil.isScopeName(dir) && NodeModulesDirectoryIconProvider.isNodeModulesDirWithMappings(project, nodeModulesDir = dir.getParent()) && (packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir)) != null && (data = PackageJsonUtil.getOrCreateData(packageJson)).containsDependencyWithScope(dir.getName());
    }

    private static boolean isNodeModulesDirWithMappings(@NotNull Project project, @NotNull VirtualFile nodeModulesDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "isNodeModulesDirWithMappings"));
        }
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "isNodeModulesDirWithMappings"));
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(nodeModulesDir)) {
            return NodeModulesDirectoryManager.getInstance(project).isNodeModulesLibraryDirWithMappings(nodeModulesDir);
        }
        return false;
    }
}

