/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.completion.ES6ImportCompletionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportExportSpecifierCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "addCompletions"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof ES6ImportExportSpecifier);
        ES6ImportExportSpecifier specifier = (ES6ImportExportSpecifier)parent;
        ResultSink sink = ES6ImportExportSpecifierCompletionProvider.createResultSink(specifier);
        List<JSType> types = ES6PsiUtil.processSpecifier(specifier, sink);
        VariantsProcessor processor = new VariantsProcessor(parent.getContainingFile(), parent, true, result);
        ES6PsiUtil.addInnerAliases(types, processor);
        JSReferenceCompletionContributor.processCompeteMatchedElements(processor);
        Iterable addedElements = ContainerUtil.concat((Iterable[])new Iterable[]{ES6ImportExportSpecifierCompletionProvider.buildResult(sink.getResults()), processor.getFinalResults()});
        result.addAllElements(addedElements);
        PsiElement importExportDeclaration = specifier.getParent();
        if (importExportDeclaration instanceof ES6ImportDeclaration && ((ES6ImportExportDeclaration)importExportDeclaration).getFromClause() == null) {
            ES6ImportCompletionUtil.addExportedVariants(specifier, addedElements, result);
        }
    }

    @NotNull
    private static Set<String> getExistingElements(@Nullable ES6ImportExportDeclaration declaration, @NotNull ES6ImportExportSpecifier current) {
        ES6ImportExportSpecifier mergedSpecifier;
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "getExistingElements"));
        }
        Stream<ES6ImportSpecifier> specifiers = null;
        PsiElement element = JSRefactoringUtil.skipWhitespaces(current.getNextSibling(), true);
        ES6ImportExportSpecifier eS6ImportExportSpecifier = mergedSpecifier = element instanceof ES6ImportExportSpecifier ? (ES6ImportExportSpecifier)element : null;
        if (declaration instanceof ES6ImportDeclaration) {
            specifiers = Arrays.stream(((ES6ImportDeclaration)declaration).getImportSpecifiers());
        }
        if (declaration instanceof ES6ExportDeclaration) {
            specifiers = Arrays.stream(((ES6ExportDeclaration)declaration).getExportSpecifiers());
        }
        if (specifiers == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "getExistingElements"));
            }
            return set;
        }
        Set<String> set = specifiers.filter(el -> {
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "lambda$getExistingElements$0"));
            }
            return el != current && el != mergedSpecifier;
        }).map(el -> el.getReferenceName()).filter(el -> el != null).collect(Collectors.toSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "getExistingElements"));
        }
        return set;
    }

    @NotNull
    public static ResultSink createResultSink(@NotNull ES6ImportExportSpecifier specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "createResultSink"));
        }
        final Set<String> existingElements = ES6ImportExportSpecifierCompletionProvider.getExistingElements(specifier.getDeclaration(), specifier);
        ResultSink resultSink = new ResultSink((PsiElement)specifier){

            @Override
            public boolean accepts(PsiElement element) {
                PsiElement module;
                if (element instanceof TypeScriptModule && ((TypeScriptModule)element).isAugmentation()) {
                    return false;
                }
                if (element instanceof PsiNamedElement && existingElements.contains(((PsiNamedElement)element).getName())) {
                    return false;
                }
                if (ES6PsiUtil.isElementCanBeExported(element) && DialectDetector.isTypeScript(element) && (module = ES6PsiUtil.findExternalModule(element)) instanceof TypeScriptModule && ((TypeScriptModule)module).isAugmentation()) {
                    return false;
                }
                return super.accepts(element);
            }

            @Override
            public String getName() {
                return null;
            }
        };
        if (resultSink == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "createResultSink"));
        }
        return resultSink;
    }

    @NotNull
    public static List<LookupElement> buildResult(@Nullable List<PsiElement> elements) {
        if (elements == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "buildResult"));
            }
            return list;
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>(elements.size());
        for (PsiElement element : elements) {
            PsiElement resolve;
            if (element instanceof ES6ImportExportSpecifier && (resolve = ((ES6ImportExportSpecifier)element).resolve()) != null) {
                element = resolve;
            }
            if (!(element instanceof PsiNamedElement)) continue;
            LookupElementBuilder builder = JSLookupUtilImpl.createLookupElement(element);
            result.add((LookupElement)builder);
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "buildResult"));
        }
        return arrayList;
    }

    @NotNull
    public static QualifiedItemProcessor<?> createCompletionProcessor(@NotNull PsiFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "createCompletionProcessor"));
        }
        QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)context).createCompletionItemProcessor(new CompletionResultSink((PsiElement)context), context);
        processor.setTypeContext(true);
        processor.setSkipImplicitDeclarations(true);
        QualifiedItemProcessor<? extends ResultSink> qualifiedItemProcessor = processor;
        if (qualifiedItemProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "createCompletionProcessor"));
        }
        return qualifiedItemProcessor;
    }
}

