/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MemberAccessCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        if (!(parent instanceof JSReferenceExpression) || ((JSReferenceExpression)parent).getQualifier() != null || JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)parent)) {
            return;
        }
        JSFunction parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class);
        if (parentFunction == null) {
            return;
        }
        final JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction);
        if (containingClass == null || DialectDetector.isActionScript((PsiElement)containingClass)) {
            return;
        }
        PsiElement context = parent.getParent();
        if (context instanceof ES6Property && ((ES6Property)context).isShorthanded()) {
            return;
        }
        final JSContext jsContext = parentFunction.getJSContext();
        final HashMap forCompletion = ContainerUtil.newHashMap();
        final HashMap typeSubstitutors = ContainerUtil.newHashMap();
        TypeScriptUtil.JSClassHierarchyProcessor processor = new TypeScriptUtil.JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor$1", "process"));
                }
                if (typeSubstitutor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitutor", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor$1", "process"));
                }
                for (JSElement element : aClass.getMembers()) {
                    String name;
                    JSAttributeList.AccessType type;
                    if (!(element instanceof JSPsiElementBase) || (type = ((JSPsiElementBase)element).getAccessType()) == JSAttributeList.AccessType.PRIVATE && !aClass.isEquivalentTo((PsiElement)containingClass) || jsContext == JSContext.STATIC && ((JSPsiElementBase)element).getJSContext() == JSContext.INSTANCE || StringUtil.isEmpty((String)(name = element.getName())) || forCompletion.containsKey(name)) continue;
                    forCompletion.put(name, (JSPsiElementBase)element);
                }
                typeSubstitutors.put(aClass, typeSubstitutor);
                return true;
            }
        };
        JSClassUtils.processClassesInHierarchy(containingClass, true, processor);
        forCompletion.values().forEach(el -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor", "lambda$fillCompletionVariants$0"));
            }
            LookupElement element = ES6MemberAccessCompletionContributor.createLookupElement(containingClass, el);
            if (element != null) {
                result.consume(element);
            }
        });
    }

    @Nullable
    private static LookupElement createLookupElement(@NotNull JSClass<?> containingClass, @NotNull JSPsiElementBase el) {
        String qualifier;
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor", "createLookupElement"));
        }
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor", "createLookupElement"));
        }
        String name = el.getName();
        assert (name != null);
        if (el.getJSContext() == JSContext.STATIC) {
            String className = containingClass.getName();
            if (className == null) {
                return null;
            }
            qualifier = className + ".";
        } else {
            qualifier = "this.";
        }
        LookupElementBuilder baseElement = JSLookupUtilImpl.createLookupElement((PsiElement)el, name);
        return PrioritizedLookupElement.withPriority((LookupElement)baseElement.withInsertHandler((handleInsert, item) -> {
            if (el == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor", "lambda$createLookupElement$1"));
            }
            handleInsert.getDocument().insertString(handleInsert.getStartOffset(), (CharSequence)qualifier);
            JSInsertHandler.insertBracesIfNeed(handleInsert, (PsiElement)el, null);
        }), (double)JSLookupPriority.RELEVANT_SMARTNESS_PRIORITY.getPriorityValue());
    }
}

