/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportHandler {
    public static final String DEFAULT_EXPORT_NAMESPACE = "\"default\"";
    private static final Key<ParameterizedCachedValue<ES6ExportCache, PsiElement>> CACHED_VALUE_KEY = Key.create((String)"es6.exported.names.cache");
    private static final ParameterizedCachedValueProvider<ES6ExportCache, PsiElement> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<ES6ExportCache, PsiElement>(){

        public CachedValueProvider.Result<ES6ExportCache> compute(PsiElement fileOrModule) {
            ES6ExportCache result = this.calcExportSpecifiersAndDefaults(JSStubBasedPsiTreeUtil.getFileOrModuleChildrenStream(fileOrModule));
            return new CachedValueProvider.Result((Object)result, new Object[]{fileOrModule});
        }

        private ES6ExportCache calcExportSpecifiersAndDefaults(Stream<? extends PsiElement> fileElements) {
            THashSet exportSpecifiers = new THashSet();
            Ref exportDefaultOrAssignment = Ref.create();
            fileElements.forEach(psi -> {
                String initializerReference;
                if (psi instanceof ES6ExportDeclaration) {
                    for (ES6ExportSpecifier exportSpecifier : ((ES6ExportDeclaration)psi).getExportSpecifiers()) {
                        String referenceName = exportSpecifier.getReferenceName();
                        if (referenceName == null || exportSpecifier.getAlias() != null) continue;
                        exportSpecifiers.add((Object)referenceName);
                    }
                } else if (psi instanceof JSExportAssignment && (initializerReference = ((JSExportAssignment)psi).getInitializerReference()) != null) {
                    exportDefaultOrAssignment.set((Object)Pair.create((Object)initializerReference, (Object)(psi instanceof ES6ExportDefaultAssignment)));
                }
            });
            return new ES6ExportCache((Pair)exportDefaultOrAssignment.get(), (Set)exportSpecifiers);
        }
    };

    public static boolean isExported(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExported"));
        }
        return element instanceof JSElementBase ? ((JSElementBase)element).isExported() : ES6ImportHandler.calculateIsExported(element);
    }

    public static boolean isExportedWithNameOrDefault(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExportedWithNameOrDefault"));
        }
        return ES6ImportHandler.isExported(element) || ES6ImportHandler.isExportedWithDefault(element);
    }

    public static boolean isExportedWithDefault(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExportedWithDefault"));
        }
        if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        return ES6ImportHandler.isExportedViaStatement(element, true, true);
    }

    public static boolean isExportWithDefaultOrAssignment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExportWithDefaultOrAssignment"));
        }
        if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        return ES6ImportHandler.isExportedViaStatement(element, true, false);
    }

    public static boolean calculateIsExported(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "calculateIsExported"));
        }
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            if (attributeList != null && attributeList.getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC) {
                return true;
            }
            if (DialectDetector.isTypeScript(element) && !(element instanceof TypeScriptImportStatement)) {
                JSFile file;
                if (element instanceof TypeScriptModule && !((TypeScriptModule)element).isInternal()) {
                    return true;
                }
                if (element.getParent() instanceof TypeScriptImplicitModule) {
                    return true;
                }
                if (element.getParent() instanceof JSFile && !(file = (JSFile)element.getParent()).isCommonJSModule()) {
                    return true;
                }
                if (TypeScriptPsiUtil.isAmbientDeclaration(element)) {
                    return true;
                }
            }
            if (DialectDetector.isJSX(element) && element instanceof JSVariable && JSXHarmonyLanguageDialect.isReactComponent(((JSVariable)element).getInitializerOrStub())) {
                return true;
            }
        }
        if (element instanceof ES6ExportSpecifierAlias || element instanceof ES6ExportedDefaultBinding) {
            return true;
        }
        return ES6ImportHandler.isExportedViaStatement(element, false, false);
    }

    public static boolean isExternalModuleExport(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExternalModuleExport"));
        }
        if (!(element instanceof JSElementBase)) {
            return false;
        }
        if (!((JSElementBase)element).isExported()) {
            return false;
        }
        if (!DialectDetector.isTypeScript((PsiElement)element)) {
            return ES6ImportHandler.isExported((PsiElement)element);
        }
        if (element instanceof ES6ExportSpecifierAlias) {
            return true;
        }
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            if (attributeList != null && attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD) != null) {
                return true;
            }
            JSExecutionScope module = ES6ImportHandler.getOwnerExternalModule((PsiElement)element);
            if (module instanceof TypeScriptModule) {
                return true;
            }
        }
        return ES6ImportHandler.isExportedViaStatement((PsiElement)element, false, false);
    }

    public static JSExecutionScope getOwnerExternalModule(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "getOwnerExternalModule"));
        }
        PsiElement parent = element.getContext();
        if (parent instanceof JSVarStatement) {
            parent = parent.getContext();
        }
        return parent instanceof JSFile && ((JSFile)parent).isCommonJSModule() || parent instanceof TypeScriptModule && !((TypeScriptModule)parent).isInternal() ? (JSExecutionScope)parent : null;
    }

    private static boolean isExportedViaStatement(@NotNull PsiElement element, boolean checkDefaultAndAssignment, boolean defaultOnly) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "isExportedViaStatement"));
        }
        String name = ES6ImportHandler.getName(element);
        ES6ExportCache exportedNames = ES6ImportHandler.getExportedViaStatementCache(element, name);
        if (exportedNames == null) {
            return false;
        }
        if (checkDefaultAndAssignment) {
            Pair reference = exportedNames.myExportDefaultOrAssignmentReference;
            return reference != null && name.equals(reference.first) && (!defaultOnly || (Boolean)reference.second != false);
        }
        return exportedNames.myNamedExports.contains(name);
    }

    @Nullable
    private static String getName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "getName"));
        }
        return element instanceof ES6ImportSpecifier ? ((ES6ImportSpecifier)element).getReferenceName() : (element instanceof JSElement ? ((JSElement)element).getName() : null);
    }

    @Nullable
    public static ES6ExportCache getExportedViaStatementCache(@NotNull PsiElement element, @Nullable String name) {
        PsiElement fileOrModule;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler", "getExportedViaStatementCache"));
        }
        if (name == null) {
            return null;
        }
        Object object = fileOrModule = element instanceof JSFile ? element : ES6PsiUtil.getExportScope(element);
        if (fileOrModule == null || !ES6PsiUtil.isExternalModule(fileOrModule)) {
            return null;
        }
        return (ES6ExportCache)CachedValuesManager.getManager((Project)fileOrModule.getProject()).getParameterizedCachedValue((UserDataHolder)fileOrModule, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, (Object)fileOrModule);
    }

    private static class ES6ExportCache {
        @Nullable
        private final Pair<String, Boolean> myExportDefaultOrAssignmentReference;
        @NotNull
        private final Set<String> myNamedExports;

        private ES6ExportCache(@Nullable Pair<String, Boolean> exportDefaultOrAssignmentReference, @NotNull Set<String> exports) {
            if (exports == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exports", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler$ES6ExportCache", "<init>"));
            }
            this.myExportDefaultOrAssignmentReference = exportDefaultOrAssignmentReference;
            this.myNamedExports = exports;
        }
    }
}

