/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.annotations.NotNull;

public class JSFileViewProviderFactory
implements FileViewProviderFactory {
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, Language language, @NotNull PsiManager manager, boolean eventSystemEnabled) {
        JSLanguageDialect jsLanguageDialect;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/JSFileViewProviderFactory", "createFileViewProvider"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/javascript/JSFileViewProviderFactory", "createFileViewProvider"));
        }
        if (!SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)file)) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        }
        if (language != null && language.isKindOf((Language)JavascriptLanguage.INSTANCE) && language != JavaScriptSupportLoader.ECMA_SCRIPT_L4 && (jsLanguageDialect = DialectDetector.getLanguageDialectForJSFile(file, manager.getProject())) != null) {
            language = jsLanguageDialect;
        }
        JSFileViewProvider jSFileViewProvider = language != null ? new JSFileViewProvider(manager, file, eventSystemEnabled, language) : new JSFileViewProvider(manager, file, eventSystemEnabled);
        if (jSFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSFileViewProviderFactory", "createFileViewProvider"));
        }
        return jSFileViewProvider;
    }

    private static class JSFileViewProvider
    extends SingleRootFileViewProvider {
        public JSFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/javascript/JSFileViewProviderFactory$JSFileViewProvider", "<init>"));
            }
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/JSFileViewProviderFactory$JSFileViewProvider", "<init>"));
            }
            super(manager, virtualFile, eventSystemEnabled);
        }

        public JSFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/javascript/JSFileViewProviderFactory$JSFileViewProvider", "<init>"));
            }
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/JSFileViewProviderFactory$JSFileViewProvider", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/JSFileViewProviderFactory$JSFileViewProvider", "<init>"));
            }
            super(manager, virtualFile, eventSystemEnabled, language);
        }

        public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
            PsiElement element;
            Language baseLanguage;
            PsiFile psi;
            if (lang == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/lang/javascript/JSFileViewProviderFactory$JSFileViewProvider", "findElementAt"));
            }
            if (lang == XMLLanguage.class && (psi = this.getPsi(baseLanguage = this.getBaseLanguage())) != null && DialectDetector.isJSX((PsiElement)psi) && (element = this.findElementAt(offset)) != null && element.getLanguage() instanceof XMLLanguage) {
                return element;
            }
            return super.findElementAt(offset, lang);
        }
    }
}

