/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.modules.TypeScriptFileModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        JSClass containingClass;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JSTargetElementEvaluator", "includeSelfInGotoImplementation"));
        }
        if (element instanceof JSFunction ? (containingClass = JSUtils.getMemberContainingClass(element)) != null && containingClass.isInterface() : element instanceof JSClass) {
            return false;
        }
        return !(element instanceof JSQualifiedNamedElement) || !TypeScriptUtil.isDefinitionFile(element.getContainingFile().getVirtualFile());
    }

    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getElementByReference"));
        }
        if (ref instanceof JSReferenceExpression) {
            ResolveResult[] results = ((JSReferenceExpression)ref).multiResolve(false);
            if (results.length > 1) {
                return JSTargetElementEvaluator.getFirstDefinitionIfDuplicates(results);
            }
        } else {
            if (JSTargetElementEvaluator.isLastTypeScriptModuleRef(ref)) {
                return JSTargetElementEvaluator.getForTypeScriptModuleRef((TypeScriptFileModuleReference)ref);
            }
            if (ref instanceof PsiMultiReference) {
                for (PsiReference reference : ((PsiMultiReference)ref).getReferences()) {
                    ES6Property property;
                    if (JSTargetElementEvaluator.isLastTypeScriptModuleRef(reference)) {
                        return JSTargetElementEvaluator.getForTypeScriptModuleRef((TypeScriptFileModuleReference)reference);
                    }
                    ES6Property eS6Property = property = reference.getElement() instanceof ES6Property ? (ES6Property)reference.getElement() : null;
                    if (!(reference instanceof JSPropertyNameReference) || property == null || !property.isShorthanded()) continue;
                    return property;
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getFirstDefinitionIfDuplicates(@NotNull ResolveResult[] results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getFirstDefinitionIfDuplicates"));
        }
        boolean first = true;
        JSQualifiedName namespace = null;
        PsiFile file = null;
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!(element instanceof JSDefinitionExpression)) {
                return null;
            }
            if (((JSDefinitionExpression)element).tryGetFunctionExpressionInitializer() != null) {
                return null;
            }
            if (first) {
                first = false;
                namespace = ((JSDefinitionExpression)element).getNamespace();
                file = element.getContainingFile();
                continue;
            }
            if (Comparing.equal(namespace, (Object)((JSDefinitionExpression)element).getNamespace()) && Comparing.equal((Object)file, (Object)element.getContainingFile())) continue;
            return null;
        }
        return results[0].getElement();
    }

    private static boolean isLastTypeScriptModuleRef(@NotNull PsiReference ref) {
        TypeScriptFileModuleReference moduleReference;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/JSTargetElementEvaluator", "isLastTypeScriptModuleRef"));
        }
        return ref instanceof TypeScriptFileModuleReference && (moduleReference = (TypeScriptFileModuleReference)ref).isLast();
    }

    @Nullable
    private static PsiElement getForTypeScriptModuleRef(@NotNull TypeScriptFileModuleReference reference) {
        Collection elements;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getForTypeScriptModuleRef"));
        }
        PsiElement element = reference.getElement();
        if (element instanceof ES6FromClause && (elements = ((ES6FromClause)element).resolveReferencedElements()).size() == 1) {
            return (PsiElement)ContainerUtil.getFirstItem((Collection)elements);
        }
        return null;
    }

    @Nullable
    public PsiElement getNamedElement(@NotNull PsiElement element) {
        ASTNode node;
        Collection implicitElements;
        JSImplicitElement implicitElement;
        JSElementIndexingData indexingData;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getNamedElement"));
        }
        PsiElement parent = element.getParent();
        if (!(element instanceof JSNamedElement) && !(element instanceof JSImplicitElementProvider) && parent instanceof JSImplicitElementProvider && (indexingData = ((JSImplicitElementProvider)parent).getIndexingData()) != null && (implicitElement = (JSImplicitElement)ContainerUtil.getFirstItem((Collection)(implicitElements = indexingData.getImplicitElements()))) != null) {
            return implicitElement;
        }
        if (parent instanceof ES6ExportDefaultAssignment && ((node = element.getNode()).getElementType() == JSTokenTypes.EXPORT_KEYWORD || node.getElementType() == JSTokenTypes.DEFAULT_KEYWORD)) {
            return parent;
        }
        if (parent instanceof JSFunction && element.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD || parent instanceof JSClass && element.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD) {
            JSQualifiedNamedElement initializedElement;
            if (parent instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)parent)) != null) {
                return initializedElement;
            }
            return parent;
        }
        return null;
    }

    @Nullable
    public PsiElement adjustTargetElement(Editor editor, int offset, int flags, @NotNull PsiElement targetElement) {
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/lang/javascript/JSTargetElementEvaluator", "adjustTargetElement"));
        }
        if (targetElement instanceof JSQualifiedNamedElement && !BitUtil.isSet((int)flags, (int)2)) {
            targetElement = JSTargetElementEvaluator.adjustTargetElement(targetElement);
        }
        return targetElement;
    }

    @Nullable
    public static PsiElement adjustTargetElement(@Nullable PsiElement targetElement) {
        TypeScriptDeclarationMappings mappings;
        JSQualifiedNamedElement sourceElement;
        if (targetElement == null) {
            return null;
        }
        if (targetElement instanceof JSQualifiedNamedElement && (sourceElement = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((mappings = TypeScriptDeclarationMappings.getInstance(targetElement.getProject())).getTSSourceElements((JSQualifiedNamedElement)targetElement))) != null) {
            targetElement = sourceElement;
        }
        return targetElement;
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getGotoDeclarationTarget"));
        }
        PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateTargetElement(element);
        if (meaningfulElement != element) {
            return meaningfulElement;
        }
        return null;
    }

    @Nullable
    public Collection<PsiElement> getTargetCandidates(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/JSTargetElementEvaluator", "getTargetCandidates"));
        }
        if (!(reference instanceof JSElement)) {
            return super.getTargetCandidates(reference);
        }
        if (reference instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference polyReference = (PsiPolyVariantReference)reference;
            ResolveResult[] results = polyReference.multiResolve(false);
            if (results == JSResolveResult.TOO_MANY_CANDIDATES) {
                if (polyReference instanceof JSReferenceExpressionImpl) {
                    results = this.resolveReferenceExpressionWithAllResolveResults((JSReferenceExpressionImpl)polyReference);
                } else {
                    return ContainerUtil.emptyList();
                }
            }
            ArrayList<PsiElement> navigatableResults = new ArrayList<PsiElement>(results.length);
            for (ResolveResult r : results) {
                PsiElement element = JSTargetElementEvaluator.adjustTargetElement(r.getElement());
                if (!TargetElementUtil.getInstance().isNavigatableSource(element)) continue;
                navigatableResults.add(element);
            }
            return navigatableResults;
        }
        PsiElement resolve = JSTargetElementEvaluator.adjustTargetElement(reference.resolve());
        return ContainerUtil.createMaybeSingletonList((Object)(TargetElementUtil.getInstance().isNavigatableSource(resolve) ? resolve : null));
    }

    @NotNull
    public ResolveResult[] resolveReferenceExpressionWithAllResolveResults(JSReferenceExpressionImpl polyReference) {
        ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)polyReference).createReferenceExpressionResolver(polyReference, true);
        ResolveResult[] resolveResultArray = resolver.resolve((PsiPolyVariantReference)polyReference, false);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSTargetElementEvaluator", "resolveReferenceExpressionWithAllResolveResults"));
        }
        return resolveResultArray;
    }
}

