/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtTaskListFetchFail {
    private static final Key<GeneralCommandLine> MARKER_KEY = Key.create((String)"jsbt task list fetch: command line");
    private final VirtualFile myBuildfile;
    private final JsbtService myService;
    private final String myBuildToolName;
    private final Icon myIcon;
    private final String myMessage;
    private final GeneralCommandLine myCommandLine;
    private final String myCommandLineFoldedText;
    private final ExecutionException myExecutionException;
    private final ProcessHandler myHandler;
    private final ProcessOutput myOutput;

    public JsbtTaskListFetchFail(@NotNull VirtualFile buildfile, @NotNull JsbtService service, @NotNull String buildToolName, @Nullable Icon icon, @NotNull String message, @NotNull GeneralCommandLine commandLine, @Nullable String commandLineFoldedText, @Nullable ExecutionException executionException, @Nullable ProcessHandler handler, @Nullable ProcessOutput output) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "<init>"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "<init>"));
        }
        if (buildToolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildToolName", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "<init>"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "<init>"));
        }
        this.myBuildfile = buildfile;
        this.myService = service;
        this.myBuildToolName = buildToolName;
        this.myIcon = icon;
        this.myMessage = message;
        this.myCommandLine = commandLine;
        this.myCommandLineFoldedText = commandLineFoldedText;
        if (executionException == null == (handler == null)) {
            throw new AssertionError((Object)"ProcessHandler and ExecutionException are mutually exclusive");
        }
        this.myExecutionException = executionException;
        if (handler == null != (output == null)) {
            throw new AssertionError((Object)"ProcessHandler and ProcessOutput: illegal configuration");
        }
        this.myHandler = handler;
        this.myOutput = output;
    }

    @NotNull
    public VirtualFile getBuildfile() {
        VirtualFile virtualFile = this.myBuildfile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "getBuildfile"));
        }
        return virtualFile;
    }

    @NotNull
    public JsbtService getService() {
        JsbtService jsbtService = this.myService;
        if (jsbtService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "getService"));
        }
        return jsbtService;
    }

    @NotNull
    public String getBuildToolName() {
        String string = this.myBuildToolName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "getBuildToolName"));
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "getMessage"));
        }
        return string;
    }

    @NotNull
    public GeneralCommandLine getCommandLine() {
        GeneralCommandLine generalCommandLine = this.myCommandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "getCommandLine"));
        }
        return generalCommandLine;
    }

    @Nullable
    public String getCommandLineFoldedText() {
        return this.myCommandLineFoldedText;
    }

    @Nullable
    public String getExecutionExceptionMessage() {
        return this.myExecutionException != null ? this.myExecutionException.getMessage() : null;
    }

    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myHandler;
    }

    @Nullable
    public ProcessOutput getProcessOutput() {
        return this.myOutput;
    }

    @NotNull
    public String getDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.myMessage);
        buf.append("\nCommand: ").append(this.myCommandLine.getCommandLineString());
        if (this.myExecutionException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.myExecutionException.printStackTrace(pw);
            pw.close();
            buf.append(sw.getBuffer());
        } else if (this.myOutput != null) {
            buf.append("\nExit code: ").append(this.myOutput.getExitCode());
            buf.append("\nSTDOUT:\n").append(this.myOutput.getStdout());
            buf.append("\nSTDERR:\n").append(this.myOutput.getStderr());
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "getDescription"));
        }
        return string;
    }

    public void associateWith(@NotNull RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "associateWith"));
        }
        MARKER_KEY.set((UserDataHolder)descriptor2.getAttachedContent(), (Object)this.myCommandLine);
    }

    public boolean isAssociatedWith(@NotNull RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListFetchFail", "isAssociatedWith"));
        }
        Content content = descriptor2.getAttachedContent();
        return MARKER_KEY.get((UserDataHolder)content) == this.myCommandLine;
    }
}

