/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsbtTaskSet {
    private final JsbtFileStructure myStructure;
    private final List<String> myTaskNames;

    public JsbtTaskSet(@NotNull JsbtFileStructure structure, @NotNull List<String> taskNames) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/buildTools/base/JsbtTaskSet", "<init>"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "com/intellij/lang/javascript/buildTools/base/JsbtTaskSet", "<init>"));
        }
        this.myStructure = structure;
        if (taskNames.isEmpty()) {
            throw new AssertionError((Object)"Not empty task name list expected");
        }
        this.myTaskNames = ImmutableList.copyOf(taskNames);
    }

    @NotNull
    public String getName() {
        String string = StringUtil.join(this.myTaskNames, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskSet", "getName"));
        }
        return string;
    }

    @NotNull
    public JsbtFileStructure getStructure() {
        JsbtFileStructure jsbtFileStructure = this.myStructure;
        if (jsbtFileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskSet", "getStructure"));
        }
        return jsbtFileStructure;
    }

    @NotNull
    public List<String> getTaskNames() {
        List<String> list = this.myTaskNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskSet", "getTaskNames"));
        }
        return list;
    }
}

