/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntUtil {
    public static final String DEFAULT_TASK_NAME = "default";
    public static final NodePackageDescriptor GRUNT = new NodePackageDescriptor("grunt-cli");
    private static final String STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH = "js.buildTools.grunt.grunt-cli.package";

    public static void checkConfiguration(@NotNull Project project, @NotNull GruntNonSharedSettings nonSharedSettings, @NotNull GruntRunSettings settings) throws RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "checkConfiguration"));
        }
        if (nonSharedSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonSharedSettings", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "checkConfiguration"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "checkConfiguration"));
        }
        GruntUtil.validateFile(settings.getGruntfilePath(), "Unspecified Gruntfile", "Gruntfile not found", null);
        NodeJsLocalInterpreter.checkForRunConfiguration(settings.getInterpreterRef().resolve(project));
        nonSharedSettings.getGruntCliPackage().validateForRunConfiguration(GRUNT.getPackageNames().get(0));
    }

    private static void validateFile(@NotNull String filePath, @NotNull String emptyPathMessage, @NotNull String fileNotFoundMessage, @Nullable String canNotExecuteFileMessage) throws RuntimeConfigurationError {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "validateFile"));
        }
        if (emptyPathMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyPathMessage", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "validateFile"));
        }
        if (fileNotFoundMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNotFoundMessage", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "validateFile"));
        }
        if (filePath.trim().isEmpty()) {
            throw new RuntimeConfigurationError(emptyPathMessage);
        }
        File file = new File(filePath);
        if (!file.isAbsolute() || !file.isFile()) {
            throw new RuntimeConfigurationError(fileNotFoundMessage);
        }
        if (canNotExecuteFileMessage != null && !file.canExecute()) {
            throw new RuntimeConfigurationError(canNotExecuteFileMessage);
        }
    }

    @NotNull
    public static String getBaseTaskName(@NotNull String fullTaskName) {
        if (fullTaskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullTaskName", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "getBaseTaskName"));
        }
        int ind = fullTaskName.indexOf(58);
        if (ind == -1) {
            String string = fullTaskName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "getBaseTaskName"));
            }
            return string;
        }
        String string = fullTaskName.substring(0, ind);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "getBaseTaskName"));
        }
        return string;
    }

    @NotNull
    public static GruntNonSharedSettings getGruntPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGruntfile) {
        NodePackage pkg;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "getGruntPackage"));
        }
        String packageDir = PropertiesComponent.getInstance((Project)project).getValue(STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH);
        if (StringUtil.isEmpty((String)packageDir) && !(pkg = GRUNT.findPreferredPackage(project, interpreter, contextGruntfile)).isEmptyPath()) {
            GruntUtil.setGruntPackage(project, pkg);
            GruntNonSharedSettings gruntNonSharedSettings = new GruntNonSharedSettings(pkg);
            if (gruntNonSharedSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "getGruntPackage"));
            }
            return gruntNonSharedSettings;
        }
        GruntNonSharedSettings gruntNonSharedSettings = new GruntNonSharedSettings(new NodePackage(StringUtil.notNullize((String)packageDir)));
        if (gruntNonSharedSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "getGruntPackage"));
        }
        return gruntNonSharedSettings;
    }

    public static void setGruntPackage(@NotNull Project project, @NotNull NodePackage gruntPackage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "setGruntPackage"));
        }
        if (gruntPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntPackage", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "setGruntPackage"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH, gruntPackage.getSystemIndependentPath());
    }
}

