/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.npm.NpmScript;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmScriptsStructure
extends JsbtFileStructure {
    private List<NpmScript> myScripts;
    private List<String> myTaskNames;

    public NpmScriptsStructure(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsStructure", "<init>"));
        }
        super(packageJson);
        this.myScripts = ImmutableList.of();
        this.myTaskNames = ImmutableList.of();
    }

    public List<NpmScript> getScripts() {
        return this.myScripts;
    }

    @Override
    @NotNull
    public List<String> getTaskNames() {
        List<String> list = this.myTaskNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsStructure", "getTaskNames"));
        }
        return list;
    }

    public void setScripts(@NotNull List<NpmScript> scripts) {
        if (scripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scripts", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsStructure", "setScripts"));
        }
        this.myScripts = ImmutableList.copyOf(scripts);
        this.myTaskNames = ImmutableList.copyOf((Collection)Lists.transform(this.myScripts, input -> input.getName()));
    }

    @Nullable
    public static NpmScriptsStructure getUserObject(@Nullable DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        return (NpmScriptsStructure)ObjectUtils.tryCast((Object)node.getUserObject(), NpmScriptsStructure.class);
    }
}

