/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.beforeRun;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.HyperlinkListeningExecutionException;
import com.intellij.lang.javascript.buildTools.npm.beforeRun.NpmBeforeRunTask;
import com.intellij.lang.javascript.buildTools.npm.beforeRun.NpmBeforeRunTaskDialog;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.PathUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmBeforeRunTaskProvider
extends BeforeRunTaskProvider<NpmBeforeRunTask> {
    static final Key<NpmBeforeRunTask> PROVIDER_ID = Key.create((String)"NpmBeforeRunTask");

    public Key<NpmBeforeRunTask> getId() {
        return PROVIDER_ID;
    }

    public String getName() {
        return JSBundle.message((String)"npm.before.run.task", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
    }

    @Nullable
    public Icon getTaskIcon(@NotNull NpmBeforeRunTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "getTaskIcon"));
        }
        return JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
    }

    public String getDescription(@NotNull NpmBeforeRunTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "getDescription"));
        }
        String path = task.getSettings().getPackageJsonSystemDependentPath();
        if (path.isEmpty()) {
            return JSBundle.message((String)"npm.before.run.task", (Object[])new Object[0]);
        }
        String fileName = PathUtil.getFileName((String)path);
        String parentPath = PathUtil.getParentPath((String)path);
        String parentName = PathUtil.getFileName((String)parentPath);
        String folderAndFile = parentName.isEmpty() ? fileName : parentName + File.separator + fileName;
        List<String> scripts = task.getSettings().getScriptNames();
        String presentableTasks = StringUtil.join(scripts, s -> "'" + s + "'", (String)", ");
        return JSBundle.message((String)"npm.before.run.task.descr", (Object[])new Object[]{scripts.size(), presentableTasks, folderAndFile});
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public NpmBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "createTask"));
        }
        return new NpmBeforeRunTask();
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull NpmBeforeRunTask task) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "configureTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "configureTask"));
        }
        NpmRunSettings oldSettings = task.getSettings();
        NpmBeforeRunTaskDialog dialog = new NpmBeforeRunTaskDialog(runConfiguration.getProject(), oldSettings);
        if (!dialog.showAndGet()) {
            return false;
        }
        NpmRunSettings newSettings = dialog.getSettings();
        if (newSettings.equals(oldSettings)) {
            return false;
        }
        task.setSettings(newSettings);
        return true;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull NpmBeforeRunTask task) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "canExecuteTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "canExecuteTask"));
        }
        try {
            NpmRunConfigurationUtil.check(configuration.getProject(), task.getSettings());
        }
        catch (RuntimeConfigurationError error) {
            return false;
        }
        return true;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull NpmBeforeRunTask task) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "executeTask"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "executeTask"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "executeTask"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "executeTask"));
        }
        try {
            NpmRunConfigurationUtil.check(configuration.getProject(), task.getSettings());
        }
        catch (RuntimeConfigurationError e) {
            String message = e.getMessage() + "<br><a href=''>Edit run configuration</a>";
            HyperlinkListeningExecutionException exception = new HyperlinkListeningExecutionException(message, () -> {
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider", "lambda$executeTask$1"));
                }
                RunManager.getInstance((Project)env.getProject()).setSelectedConfiguration(env.getRunnerAndConfigurationSettings());
                new EditConfigurationsDialog(env.getProject()).show();
            });
            ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)ToolWindowId.RUN, (String)"Npm script before launch", (Throwable)((Object)exception));
            return false;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)env.getProject()).createRunConfiguration("", NpmConfigurationType.getFactory());
        NpmRunConfigurationProducer.setupConfigurationFromSettings((NpmRunConfiguration)settings.getConfiguration(), task.getSettings());
        return RunConfigurationBeforeRunProvider.doExecuteTask((ExecutionEnvironment)env, (RunnerAndConfigurationSettings)settings);
    }
}

