/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBinaryExpressionBlock
extends JSBlock {
    private final CommonCodeStyleSettings myCommonSettings;

    public JSBinaryExpressionBlock(@NotNull ASTNode child, Alignment alignment, Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @NotNull JSBlockContext jsBlockContext) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JSBinaryExpressionBlock", "<init>"));
        }
        if (jsBlockContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsBlockContext", "com/intellij/lang/javascript/formatter/JSBinaryExpressionBlock", "<init>"));
        }
        super(child, alignment, Indent.getNoneIndent(), wrap, alignmentFactory, jsBlockContext);
        this.myCommonSettings = jsBlockContext.getCommonSettings();
    }

    @Override
    @NotNull
    public List<Block> buildChildren() {
        ArrayList subExpressions = ContainerUtil.newArrayList();
        JSBinaryExpressionBlock.collectExpressions(this.myNode, subExpressions);
        Indent smartIndent = Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION);
        ASTNode first = (ASTNode)subExpressions.get(0);
        List list = ContainerUtil.map((Collection)subExpressions, child -> {
            boolean isFirst = child == first;
            Alignment childAlignment = this.mySharedAlignmentFactory != null ? this.mySharedAlignmentFactory.getAlignment((ASTNode)child) : null;
            Wrap childWrap = this.getChildWrap((ASTNode)child, isFirst);
            return this.myBlockContext.createBlock((ASTNode)child, childWrap, childAlignment, smartIndent, this.mySharedAlignmentFactory, this);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSBinaryExpressionBlock", "buildChildren"));
        }
        return list;
    }

    @Nullable
    private Wrap getChildWrap(@NotNull ASTNode child, boolean isFirst) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/JSBinaryExpressionBlock", "getChildWrap"));
        }
        boolean isOperationSign = JSExtendedLanguagesTokenSetProvider.OPERATIONS.contains(child.getElementType());
        return !isFirst && isOperationSign == this.myCommonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? this.getCurrentWrap(this.myCommonSettings.BINARY_OPERATION_WRAP) : null;
    }

    @Override
    protected Spacing calculateSpacing(ASTNode child1, ASTNode child2) {
        if (JSFormatterUtil.isInlineEndOfLineComment(child2)) {
            return Spacing.getReadOnlySpacing();
        }
        IElementType type1 = child1.getElementType();
        IElementType type2 = child2.getElementType();
        if (type2 == JSElementTypes.PREFIX_EXPRESSION || type1 == JSTokenTypes.INSTANCEOF_KEYWORD || type2 == JSTokenTypes.INSTANCEOF_KEYWORD) {
            return this.getSingleSpace(true);
        }
        IElementType opSign = null;
        if (JSExtendedLanguagesTokenSetProvider.OPERATIONS.contains(type1)) {
            opSign = type1;
        } else if (JSExtendedLanguagesTokenSetProvider.OPERATIONS.contains(type2)) {
            opSign = type2;
        }
        if (opSign != null) {
            return this.getSingleSpace(JSSpacingProcessor.getSpaceAroundSign(opSign, this.myCommonSettings));
        }
        return super.calculateSpacing(child1, child2);
    }

    protected Spacing getSingleSpace(boolean needSpace) {
        int spaces = needSpace ? 1 : 0;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myCommonSettings.KEEP_LINE_BREAKS, (int)this.myCommonSettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static void collectExpressions(@NotNull ASTNode rootNode, @NotNull ArrayList<ASTNode> results) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/lang/javascript/formatter/JSBinaryExpressionBlock", "collectExpressions"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/formatter/JSBinaryExpressionBlock", "collectExpressions"));
        }
        for (ASTNode child = rootNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (JSElementTypes.BINARY_EXPRESSION == child.getElementType()) {
                JSBinaryExpressionBlock.collectExpressions(child, results);
                continue;
            }
            if (child.getElementType() == JSTokenTypes.WHITE_SPACE || child.getTextRange().getLength() <= 0) continue;
            results.add(child);
        }
    }
}

