/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavascriptFormattingModelBuilder
implements FormattingModelBuilderEx {
    public static final Key<Alignment> BLOCK_ALIGNMENT = Key.create((String)"js.block.alignment");

    public static FormattingModel createJSFormattingModel(PsiFile file, CodeStyleSettings settings, Block rootBlock) {
        Document document = FormattingDocumentModelImpl.getDocumentToBeUsedFor((PsiFile)file);
        if (document != null && FormattingDocumentModelImpl.canUseDocumentModel((Document)document, (PsiFile)file) && file instanceof JSFile && file.getContext() == null) {
            return new DocumentBasedFormattingModel(rootBlock, file.getProject(), settings, file.getFileType(), file);
        }
        return FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)file, (Block)rootBlock, (CodeStyleSettings)settings);
    }

    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createModel"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createModel"));
        }
        Language dialect = JSLanguageUtil.getLanguageDialect(element);
        Alignment alignment = (Alignment)element.getNode().getUserData(BLOCK_ALIGNMENT);
        JSBlockContext jsBlockContext = this.createBlockFactory(settings, dialect, mode);
        Block rootBlock = jsBlockContext.createBlock(element.getNode(), null, alignment, null, null, null);
        FormattingModel formattingModel = JavascriptFormattingModelBuilder.createJSFormattingModel(element.getContainingFile(), settings, rootBlock);
        XmlFormattingPolicy xmlFormattingPolicy = JavascriptFormattingModelBuilder.getPolicy(element, settings, formattingModel.getDocumentModel());
        jsBlockContext.setXmlFormattingPolicy(xmlFormattingPolicy);
        FormattingModel formattingModel2 = formattingModel;
        if (formattingModel2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createModel"));
        }
        return formattingModel2;
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FormattingModel formattingModel = this.createModel(element, settings, FormattingMode.REFORMAT);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    @NotNull
    protected JSBlockContext createBlockFactory(CodeStyleSettings settings, Language dialect, FormattingMode mode) {
        JSBlockContext jSBlockContext = new JSBlockContext(settings, dialect, null, mode);
        if (jSBlockContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "createBlockFactory"));
        }
        return jSBlockContext;
    }

    @NotNull
    private static XmlFormattingPolicy getPolicy(PsiElement element, CodeStyleSettings settings, FormattingDocumentModel model) {
        Object object = DialectDetector.isJSX(element) ? new HtmlPolicy(settings, model){

            public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
                PsiElement parent = tag.getParent();
                if (JavascriptFormattingModelBuilder.isRestrictedProduction(parent)) {
                    return WrapType.NONE;
                }
                if (!(parent instanceof XmlTag)) {
                    return WrapType.NORMAL;
                }
                return super.getWrappingTypeForTagBegin(tag);
            }

            public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
                return false;
            }

            protected boolean isInlineTag(XmlTag tag) {
                return StringUtil.isCapitalized((String)tag.getName()) || super.isInlineTag(tag);
            }
        } : new XmlPolicy(settings, model){

            public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
                if (!(tag.getParent() instanceof XmlTag)) {
                    return WrapType.NORMAL;
                }
                return super.getWrappingTypeForTagBegin(tag);
            }
        };
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "getPolicy"));
        }
        return object;
    }

    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return null;
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        return null;
    }

    private static boolean isRestrictedProduction(@Nullable PsiElement parent) {
        return parent instanceof JSReturnStatement || parent instanceof JSYieldExpression || parent instanceof JSThrowStatement;
    }
}

