/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVarStatementAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private final JSCodeStyleSettings myJSCodeStyleSettings;
    private Alignment myEqualsSignAlignment;
    private Alignment myIdentifierAlignment;

    public JSVarStatementAlignmentFactory(JSCodeStyleSettings jsCodeStyleSettings) {
        this.myJSCodeStyleSettings = jsCodeStyleSettings;
        this.resetAlignments();
    }

    @Override
    public Alignment getAlignment(@NotNull ASTNode child) {
        ASTNode parent;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/alignment/JSVarStatementAlignmentFactory", "getAlignment"));
        }
        IElementType childType = child.getElementType();
        if (this.myJSCodeStyleSettings.ALIGN_VAR_STATEMENTS != 0 && (parent = child.getTreeParent()) != null) {
            IElementType parentType = parent.getElementType();
            if ((JSElementTypes.BODY_VARIABLES.contains(parentType) || parentType == JSStubElementTypes.DESTRUCTURING_ELEMENT) && child.getElementType() == JSTokenTypes.EQ) {
                return this.myEqualsSignAlignment;
            }
            if (JSElementTypes.VAR_STATEMENTS.contains(parentType)) {
                if (this.shouldRestartAlignment(parent, child)) {
                    this.resetAlignments();
                }
                if (!JSTokenTypes.VAR_MODIFIERS.contains(childType) && childType != JSTokenTypes.SEMICOLON && childType != JSTokenTypes.COMMA && parent.getFirstChildNode() != child) {
                    return this.myIdentifierAlignment;
                }
            } else if (parentType == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
                ASTNode statement = parent.getTreeParent();
                if (!JSVarStatementAlignmentFactory.isAssignmentExpression(statement) || this.shouldRestartAlignment(statement, child)) {
                    this.resetAlignments();
                }
                if (childType == JSTokenTypes.EQ) {
                    return this.myEqualsSignAlignment;
                }
            }
        }
        return null;
    }

    private boolean shouldRestartAlignment(@NotNull ASTNode statement, @NotNull ASTNode child) {
        ASTNode beforeStatement;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/formatter/blocks/alignment/JSVarStatementAlignmentFactory", "shouldRestartAlignment"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/alignment/JSVarStatementAlignmentFactory", "shouldRestartAlignment"));
        }
        int statementStart = JSVarStatementAlignmentFactory.getStatementStartSkipComments(statement);
        if (statementStart == -1) {
            return true;
        }
        if (statementStart != child.getTextRange().getStartOffset()) {
            return false;
        }
        if (this.myJSCodeStyleSettings.ALIGN_VAR_STATEMENTS == 2 && (beforeStatement = JSVarStatementAlignmentFactory.getPrevSiblingStatement(statement)) != null) {
            IElementType typeBefore = beforeStatement.getElementType();
            if (JSVarStatementAlignmentFactory.isAssignmentExpression(beforeStatement) || JSElementTypes.VAR_STATEMENTS.contains(typeBefore)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static ASTNode getPrevSiblingStatement(@NotNull ASTNode statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/formatter/blocks/alignment/JSVarStatementAlignmentFactory", "getPrevSiblingStatement"));
        }
        ASTNode prev = statement.getTreePrev();
        if (prev instanceof PsiWhiteSpace) {
            if (StringUtil.getLineBreakCount((CharSequence)prev.getChars()) > 1) {
                return null;
            }
            prev = prev.getTreePrev();
        }
        if (prev != null) {
            if (prev.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && (prev = prev.getTreePrev()) instanceof PsiWhiteSpace) {
                if (StringUtil.getLineBreakCount((CharSequence)prev.getChars()) > 1) {
                    return null;
                }
                prev = prev.getTreePrev();
            }
            return prev;
        }
        return null;
    }

    private static boolean isAssignmentExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/blocks/alignment/JSVarStatementAlignmentFactory", "isAssignmentExpression"));
        }
        if (node.getElementType() == JSElementTypes.EXPRESSION_STATEMENT) {
            ASTNode child = node.getFirstChildNode();
            return child != null && child.getElementType() == JSStubElementTypes.ASSIGNMENT_EXPRESSION;
        }
        return false;
    }

    private void resetAlignments() {
        this.myEqualsSignAlignment = Alignment.createAlignment((boolean)true);
        this.myIdentifierAlignment = Alignment.createAlignment();
    }

    private static int getStatementStartSkipComments(@NotNull ASTNode statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/formatter/blocks/alignment/JSVarStatementAlignmentFactory", "getStatementStartSkipComments"));
        }
        for (ASTNode child = statement.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiElement psiElement = child.getPsi();
            if (psiElement instanceof PsiComment || psiElement instanceof PsiWhiteSpace) continue;
            return child.getTextRange().getStartOffset();
        }
        return -1;
    }
}

