/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.systemjs;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSConfig;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSPathSubstitution;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSCustomStringIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemJSConfigFinder {
    public static final String BASE_URL = "baseURL";
    public static final String PATHS = "paths";
    public static final String MAPPINGS = "map";
    private static final Key<ParameterizedCachedValue<SystemJSConfig, Collection<JSObjectLiteralExpression>>> CACHED_VALUE_KEY = Key.create((String)"TypeScript.System.JS");
    private static final ParameterizedCachedValueProvider<SystemJSConfig, Collection<JSObjectLiteralExpression>> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<SystemJSConfig, Collection<JSObjectLiteralExpression>>(){

        public CachedValueProvider.Result<SystemJSConfig> compute(Collection<JSObjectLiteralExpression> expressions) {
            SystemJSConfig config2 = SystemJSConfigFinder.parseConfigImpl(expressions);
            return CachedValueProvider.Result.create((Object)config2, expressions);
        }
    };

    public Collection<SystemJSConfig> getConfigs(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getConfigs"));
        }
        return this.getConfigsImpl(context);
    }

    protected Collection<SystemJSConfig> getConfigsImpl(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getConfigsImpl"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)context.getProject())) {
            return ContainerUtil.emptyList();
        }
        Collection<JSObjectLiteralExpression> literals = SystemJSConfigFinder.getConfigLiterals(context);
        if (literals.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        MultiMap map = MultiMap.createLinkedSet();
        literals.forEach(el -> map.putValue((Object)el.getContainingFile(), el));
        return map.entrySet().stream().map(entry -> SystemJSConfigFinder.parseConfig((PsiElement)entry.getKey(), (Collection)entry.getValue())).filter(el -> el != null).collect(Collectors.toList());
    }

    @NotNull
    private static Collection<JSObjectLiteralExpression> getConfigLiterals(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getConfigLiterals"));
        }
        Collection elements = StubIndex.getElements(JSCustomStringIndex.KEY, (Object)"System.config", (Project)context.getProject(), (GlobalSearchScope)JSResolveUtil.getResolveScope(context), PsiElement.class);
        Collection collection = elements.stream().map(el -> (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)el, JSObjectLiteralExpression.class)).filter(el -> el != null).filter(el -> {
            VirtualFile configFile = PsiUtilCore.getVirtualFile((PsiElement)el);
            return configFile != null && !JSLibraryUtil.isProbableLibraryFile(configFile);
        }).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getConfigLiterals"));
        }
        return collection;
    }

    private static SystemJSConfig parseConfig(PsiElement context, @NotNull Collection<JSObjectLiteralExpression> expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "parseConfig"));
        }
        return (SystemJSConfig)CachedValuesManager.getManager((Project)context.getProject()).getParameterizedCachedValue((UserDataHolder)context, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, expressions);
    }

    @Nullable
    private static SystemJSConfig parseConfigImpl(@NotNull Collection<JSObjectLiteralExpression> expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "parseConfigImpl"));
        }
        VirtualFile file = null;
        VirtualFile configFile = null;
        for (JSObjectLiteralExpression expression : expressions) {
            configFile = PsiUtilCore.getVirtualFile((PsiElement)expression);
            if (configFile == null) continue;
            String url = SystemJSConfigFinder.getBaseURL(expression);
            if (url != null) {
                file = SystemJSConfigFinder.getBaseURLFile(configFile.getParent(), url);
                break;
            }
            if (file != null) continue;
            file = SystemJSConfigFinder.getBaseURLFile(configFile.getParent(), null);
        }
        if (file == null || configFile == null) {
            return null;
        }
        final VirtualFile virtualFile = file;
        final VirtualFile virtualConfigFile = configFile;
        final Collection<SystemJSPathSubstitution> substitutions = SystemJSConfigFinder.getAllSubstitutions(expressions);
        if (substitutions.isEmpty()) {
            return null;
        }
        return new SystemJSConfig(){

            @Override
            public VirtualFile getBaseURL() {
                return virtualFile;
            }

            @Override
            public VirtualFile rootDirectory() {
                return virtualConfigFile.getParent();
            }

            @Override
            public Collection<SystemJSPathSubstitution> getMappings() {
                return substitutions;
            }
        };
    }

    @NotNull
    private static Collection<SystemJSPathSubstitution> getPathsSubstitutions(@NotNull Collection<JSObjectLiteralExpression> expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getPathsSubstitutions"));
        }
        HashMap rawPaths = null;
        for (JSObjectLiteralExpression expression : expressions) {
            Map<String, String> values = SystemJSConfigFinder.getValues(expression, PATHS);
            if (values == null) continue;
            if (rawPaths == null) {
                rawPaths = ContainerUtil.newHashMap();
            }
            rawPaths.putAll(values);
        }
        Collection<SystemJSPathSubstitution> collection = SystemJSConfigFinder.convertToSubstitutions(rawPaths, SystemJSPathSubstitution.SystemJSPathSubstitutionType.PATH);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getPathsSubstitutions"));
        }
        return collection;
    }

    private static Collection<SystemJSPathSubstitution> getAllSubstitutions(@NotNull Collection<JSObjectLiteralExpression> expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getAllSubstitutions"));
        }
        Collection result = null;
        Collection<SystemJSPathSubstitution> paths = SystemJSConfigFinder.getPathsSubstitutions(expressions);
        for (JSObjectLiteralExpression expression : expressions) {
            Collection<SystemJSPathSubstitution> substitutions = SystemJSConfigFinder.getAllSubstitutions(paths, expression);
            if (substitutions.isEmpty()) continue;
            if (result == null) {
                result = ContainerUtil.newArrayList();
            }
            result.addAll(substitutions);
        }
        if (result == null) {
            return paths;
        }
        result.addAll(paths);
        return result;
    }

    private static Collection<SystemJSPathSubstitution> getAllSubstitutions(Collection<SystemJSPathSubstitution> paths, @NotNull JSObjectLiteralExpression expression) {
        Collection<Object> mappings;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getAllSubstitutions"));
        }
        Map<String, String> rawMappings = SystemJSConfigFinder.getValues(expression, MAPPINGS);
        if (paths.isEmpty() || rawMappings == null) {
            mappings = SystemJSConfigFinder.convertToSubstitutions(rawMappings, SystemJSPathSubstitution.SystemJSPathSubstitutionType.MAP);
        } else {
            mappings = ContainerUtil.newArrayList();
            for (Map.Entry<String, String> entry : rawMappings.entrySet()) {
                String pattern = entry.getKey();
                String mapping = entry.getValue();
                Pair<SystemJSPathSubstitution, String> matchedElement = JSPathMappingsUtil.findMaxElementByPaths(mapping, paths);
                if (matchedElement == null) {
                    mappings.add(new SystemJSPathSubstitution(pattern, mapping, SystemJSPathSubstitution.SystemJSPathSubstitutionType.MAP));
                    continue;
                }
                String newMapping = SystemJSConfigFinder.getSubstitutedString(mapping, matchedElement);
                mappings.add(new SystemJSPathSubstitution(pattern, newMapping, SystemJSPathSubstitution.SystemJSPathSubstitutionType.MAP));
            }
        }
        return mappings;
    }

    private static String getSubstitutedString(String stringToProcess, Pair<SystemJSPathSubstitution, String> matchedElement) {
        JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)matchedElement.getFirst();
        String matchedStar = StringUtil.nullize((String)((String)matchedElement.getSecond()));
        String pattern = matchedPattern.getPattern();
        String patternExact = matchedStar != null ? pattern.replace("*", matchedStar) : pattern;
        String replaceBy = (String)ContainerUtil.getFirstItem(matchedPattern.getMappings());
        assert (replaceBy != null);
        String replaceByExact = matchedStar != null ? replaceBy.replace("*", matchedStar) : replaceBy;
        return stringToProcess.replace(patternExact, replaceByExact);
    }

    @NotNull
    private static VirtualFile getBaseURLFile(VirtualFile file, @Nullable String baseURL) {
        assert (file != null);
        if (baseURL == null || "/".equals(baseURL) || ".".equals(baseURL)) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getBaseURLFile"));
            }
            return virtualFile;
        }
        VirtualFile url = JSPathMappingsUtil.getPathRelativeBaseUrl(file, baseURL);
        VirtualFile virtualFile = url == null ? file : url;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getBaseURLFile"));
        }
        return virtualFile;
    }

    @Nullable
    private static String getBaseURL(@NotNull JSObjectLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getBaseURL"));
        }
        JSProperty property = expression.findProperty(BASE_URL);
        if (property == null) {
            return null;
        }
        return SystemJSConfigFinder.getPropertyValueAsString(property);
    }

    @Nullable
    private static String getPropertyValueAsString(JSProperty property) {
        JSLiteralExpression expression = property.getLiteralExpressionInitializer();
        if (expression == null) {
            return null;
        }
        String significantValue = expression.getSignificantValue();
        return significantValue == null ? null : StringUtil.unquoteString((String)significantValue);
    }

    @Nullable
    private static Map<String, String> getValues(@NotNull JSObjectLiteralExpression expression, String propertyName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getValues"));
        }
        JSProperty paths = expression.findProperty(propertyName);
        if (paths == null) {
            return null;
        }
        JSObjectLiteralExpression pathsExpression = paths.getObjectLiteralExpressionInitializer();
        if (pathsExpression == null) {
            return null;
        }
        JSProperty[] properties = pathsExpression.getProperties();
        if (properties.length == 0) {
            return null;
        }
        HashMap result = ContainerUtil.newHashMap();
        for (JSProperty property : properties) {
            String name = property.getName();
            String value = SystemJSConfigFinder.getPropertyValueAsString(property);
            if (StringUtil.isEmptyOrSpaces((String)name) || StringUtil.isEmptyOrSpaces((String)value)) continue;
            result.put(name, value);
        }
        return result;
    }

    @NotNull
    private static Collection<SystemJSPathSubstitution> convertToSubstitutions(@Nullable Map<String, String> elements, @NotNull SystemJSPathSubstitution.SystemJSPathSubstitutionType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "convertToSubstitutions"));
        }
        if (elements == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "convertToSubstitutions"));
            }
            return list;
        }
        Collection collection = elements.entrySet().stream().map(el -> {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "lambda$convertToSubstitutions$6"));
            }
            return new SystemJSPathSubstitution((String)el.getKey(), (String)el.getValue(), type);
        }).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "convertToSubstitutions"));
        }
        return collection;
    }
}

