/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.stubs.JSAttributeNameValuePairStub;
import com.intellij.lang.javascript.psi.stubs.JSAttributeStub;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.lang.javascript.psi.stubs.JSDefinitionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSFunctionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStub;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceDeclarationStub;
import com.intellij.lang.javascript.psi.stubs.JSPackageStatementStub;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.stubs.JSPropertyStub;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringTokenizer;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPackageIndex
extends FileBasedIndexExtension<String, List<JSPackageIndexInfo>> {
    private static final int myVersion = 12;
    public static final ID<String, List<JSPackageIndexInfo>> INDEX_ID = ID.create((String)"js.package.index");
    private static final int KIND_MASK = 15;
    private static final int PUBLIC_MASK = 4;
    private final DataIndexer<String, List<JSPackageIndexInfo>, FileContent> myIndexer = new DataIndexer<String, List<JSPackageIndexInfo>, FileContent>(){

        @NotNull
        public Map<String, List<JSPackageIndexInfo>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/lang/javascript/index/JSPackageIndex$1", "map"));
            }
            THashMap map = new THashMap();
            StubTree tree = JSPackageIndex.getStubTree(inputData);
            if (tree == null) {
                Map<String, List<JSPackageIndexInfo>> map2 = Collections.emptyMap();
                if (map2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSPackageIndex$1", "map"));
                }
                return map2;
            }
            List elementList = tree.getPlainList();
            int size = elementList.size();
            for (int i = 0; i < size; ++i) {
                StubElement parentStub;
                StubElement e = (StubElement)elementList.get(i);
                JSQualifiedStub element = null;
                boolean isPublic = false;
                if (e instanceof JSQualifiedStub) {
                    element = (JSQualifiedStub)e;
                }
                if (e instanceof JSParameterStub || e instanceof JSFunctionExpressionStub || e instanceof JSDefinitionExpressionStub || e instanceof JSPropertyStub) {
                    element = null;
                } else if (e instanceof JSFunctionStub || e instanceof JSVariableStub) {
                    parentStub = e.getParentStub();
                    if (parentStub instanceof JSVarStatementStub) {
                        parentStub = parentStub.getParentStub();
                    }
                    if (!(parentStub instanceof JSPackageStatementStub) && !(parentStub instanceof PsiFileStub)) {
                        element = null;
                    }
                    if (i + 1 < size && elementList.get(i + 1) instanceof JSAttributeListStub) {
                        isPublic = ((JSAttributeListStub)elementList.get(i + 1)).getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC;
                    }
                } else if (e instanceof JSClassStub) {
                    if (i + 1 < size && elementList.get(i + 1) instanceof JSAttributeListStub) {
                        isPublic = ((JSAttributeListStub)elementList.get(i + 1)).getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC;
                        i += 2;
                        while (i < size) {
                            StubElement maybeAttrStub = (StubElement)elementList.get(i);
                            if (maybeAttrStub instanceof JSAttributeNameValuePairStub) {
                                ++i;
                                continue;
                            }
                            if (!(maybeAttrStub instanceof JSAttributeStub)) {
                                --i;
                                break;
                            }
                            if ("ExcludeClass".equals(((JSAttributeStub)maybeAttrStub).getName())) {
                                isPublic = false;
                            }
                            ++i;
                        }
                    }
                    if ((parentStub = e.getParentStub()) instanceof PsiFileStub && (element.getName() == null || StringUtil.getPackageName((String)element.getQualifiedName()).length() == 0 && !isPublic)) continue;
                }
                if (element == null) continue;
                this.indexQualifiedElement(element, (Map<String, List<JSPackageIndexInfo>>)map, isPublic);
            }
            THashMap tHashMap = map;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSPackageIndex$1", "map"));
            }
            return tHashMap;
        }

        private void indexQualifiedElement(JSQualifiedStub element, Map<String, List<JSPackageIndexInfo>> map, boolean isPublic) {
            String qName = element.getQualifiedName();
            if (qName != null) {
                JSPackageIndexInfo.Kind kind = element instanceof JSClassStub ? (((JSClassStub)element).isInterface() ? JSPackageIndexInfo.Kind.INTERFACE : JSPackageIndexInfo.Kind.CLASS) : (element instanceof JSFunctionStub ? JSPackageIndexInfo.Kind.FUNCTION : (element instanceof JSVariableStub || element instanceof JSNamespaceDeclarationStub ? JSPackageIndexInfo.Kind.VARIABLE : JSPackageIndexInfo.Kind.PACKAGE));
                StringTokenizer tokenizer = new StringTokenizer(qName, ".");
                StringBuilder builder = new StringBuilder(qName.length());
                String el = null;
                while (tokenizer.hasMoreElements()) {
                    if (el != null) {
                        if (builder.length() != 0) {
                            builder.append('.');
                        }
                        builder.append(el);
                    }
                    el = tokenizer.nextElement();
                    JSPackageIndexInfo.Kind currentKind = tokenizer.hasMoreElements() ? JSPackageIndexInfo.Kind.PACKAGE : kind;
                    String key = builder.length() != 0 ? builder.toString() : "";
                    SmartList infoList = map.get(key);
                    boolean toAdd = true;
                    if (infoList == null) {
                        infoList = new SmartList();
                        map.put(key, (List<JSPackageIndexInfo>)infoList);
                    } else {
                        int size = infoList.size();
                        for (int i = 0; i < size; ++i) {
                            if (!((JSPackageIndexInfo)infoList.get(i)).isEquivalentTo(el, currentKind, isPublic)) continue;
                            toAdd = false;
                            break;
                        }
                    }
                    if (!toAdd) continue;
                    infoList.add(new JSPackageIndexInfo(el, currentKind, isPublic));
                }
            }
        }
    };
    private final DataExternalizer<List<JSPackageIndexInfo>> myDataExternalizer = new DataExternalizer<List<JSPackageIndexInfo>>(){
        private final JSPackageIndexInfo.Kind[] kinds = JSPackageIndexInfo.Kind.values();

        public void save(@NotNull DataOutput out, List<JSPackageIndexInfo> value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/lang/javascript/index/JSPackageIndex$2", "save"));
            }
            out.writeInt(value.size());
            for (JSPackageIndexInfo s : value) {
                out.writeByte(s.kind.ordinal() & 0xF | (s.isPublic ? 1 : 0) << 4);
                IOUtil.writeUTF((DataOutput)out, (String)s.name);
            }
        }

        public List<JSPackageIndexInfo> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/lang/javascript/index/JSPackageIndex$2", "read"));
            }
            int size = in.readInt();
            ArrayList<JSPackageIndexInfo> strings = new ArrayList<JSPackageIndexInfo>(size);
            while (size-- > 0) {
                byte b = in.readByte();
                JSPackageIndexInfo.Kind kind = this.kinds[b & 0xF];
                String s = IOUtil.readUTF((DataInput)in);
                strings.add(new JSPackageIndexInfo(s, kind, b >>> 4 == 1));
            }
            return strings;
        }
    };

    @Nullable
    public static StubTree getStubTree(FileContent inputData) {
        Stub rootStub = StubTreeBuilder.buildStubTree((FileContent)inputData);
        if (!(rootStub instanceof PsiFileStub)) {
            return null;
        }
        return new StubTree((PsiFileStub)rootStub);
    }

    public static String buildQualifiedName(String packageName, String className) {
        return (packageName != null && packageName.length() > 0 ? packageName + "." : "") + className;
    }

    @NotNull
    public ID<String, List<JSPackageIndexInfo>> getName() {
        ID<String, List<JSPackageIndexInfo>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSPackageIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public Collection<FileType> getFileTypesWithSizeLimitNotApplicable() {
        ArrayList<FileType> result = new ArrayList<FileType>();
        ContainerUtil.addIfNotNull(result, (Object)Holder.ourSwfFileType);
        ContainerUtil.addIfNotNull(result, (Object)Holder.ourRblFileType);
        ArrayList<FileType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSPackageIndex", "getFileTypesWithSizeLimitNotApplicable"));
        }
        return arrayList;
    }

    @NotNull
    public DataIndexer<String, List<JSPackageIndexInfo>, FileContent> getIndexer() {
        DataIndexer<String, List<JSPackageIndexInfo>, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSPackageIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSPackageIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<JSPackageIndexInfo>> getValueExternalizer() {
        DataExternalizer<List<JSPackageIndexInfo>> dataExternalizer = this.myDataExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSPackageIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{ActionScriptFileType.INSTANCE, Holder.ourRblFileType, Holder.ourSwfFileType}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSPackageIndex$3", "acceptInput"));
                }
                return file.getFileType() != Holder.ourSwfFileType || file.getFileSystem().getProtocol().equals("jar");
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSPackageIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 12;
    }

    public static boolean processElementsInScope(@NotNull String packageName, final @Nullable String targetName, final PackageElementsProcessor processor, GlobalSearchScope searchScope, Project project) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/index/JSPackageIndex", "processElementsInScope"));
        }
        THashMap indexValues = new THashMap();
        FileBasedIndex.ValueProcessor indexProcessor = (file, members) -> {
            indexValues.put((Object)file, members);
            return true;
        };
        if (targetName == null) {
            FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)packageName, null, indexProcessor, searchScope);
        } else {
            String target = JSPackageIndex.buildQualifiedName(packageName, targetName);
            FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)target, null, indexProcessor, searchScope);
        }
        boolean b = indexValues.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<VirtualFile, List<JSPackageIndexInfo>>(){

            public boolean execute(VirtualFile file, List<JSPackageIndexInfo> members) {
                if (targetName != null) {
                    return processor.process(file, targetName, JSPackageIndexInfo.Kind.PACKAGE, true);
                }
                for (JSPackageIndexInfo className : members) {
                    if (processor.process(file, className.name, className.kind, className.isPublic)) continue;
                    return false;
                }
                return true;
            }
        });
        if (b) {
            Processor vfileProcessor = virtualFile -> {
                JSPackageIndexInfo.Kind kind = null;
                if (virtualFile.isDirectory()) {
                    kind = JSPackageIndexInfo.Kind.PACKAGE;
                } else if (JavaScriptSupportLoader.isMxmlOrFxgFile(virtualFile)) {
                    kind = JSPackageIndexInfo.Kind.CLASS;
                }
                if (kind == null) {
                    return true;
                }
                return processor.process((VirtualFile)virtualFile, virtualFile.getNameWithoutExtension(), kind, true);
            };
            for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions(JSResolveHelper.EP_NAME)) {
                if (helper.processPackage(packageName, targetName, (Processor<VirtualFile>)vfileProcessor, searchScope, project)) continue;
                return false;
            }
        }
        return b;
    }

    public static boolean processElementsInScopeRecursive(@NotNull String packageName, final PackageQualifiedElementsProcessor processor, GlobalSearchScope searchScope, Project project) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/index/JSPackageIndex", "processElementsInScopeRecursive"));
        }
        THashSet packagesToProcess = new THashSet();
        packagesToProcess.add(packageName);
        while (!packagesToProcess.isEmpty()) {
            final String currentPackage = (String)ContainerUtil.getFirstItem((Collection)packagesToProcess, null);
            if (!JSPackageIndex.processElementsInScope(currentPackage, null, new PackageElementsProcessor((Collection)packagesToProcess){
                final /* synthetic */ Collection val$packagesToProcess;
                {
                    this.val$packagesToProcess = collection;
                }

                @Override
                public boolean process(VirtualFile file, String name, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                    String qualifiedName = JSPackageIndex.buildQualifiedName(currentPackage, name);
                    if (!processor.process(qualifiedName, kind, isPublic)) {
                        return false;
                    }
                    if (kind == JSPackageIndexInfo.Kind.PACKAGE) {
                        this.val$packagesToProcess.add(qualifiedName);
                    }
                    return true;
                }
            }, searchScope, project)) {
                return false;
            }
            packagesToProcess.remove(currentPackage);
        }
        return true;
    }

    public static interface PackageQualifiedElementsProcessor {
        public boolean process(String var1, JSPackageIndexInfo.Kind var2, boolean var3);
    }

    public static interface PackageElementsProcessor {
        public boolean process(VirtualFile var1, String var2, JSPackageIndexInfo.Kind var3, boolean var4);
    }

    private static class Holder {
        private static final FileType ourSwfFileType;
        private static final FileType ourRblFileType;

        private Holder() {
        }

        static {
            FileType swfFileType = FileTypeRegistry.getInstance().getFileTypeByExtension("swf");
            if (swfFileType == UnknownFileType.INSTANCE) {
                swfFileType = null;
            }
            ourSwfFileType = swfFileType;
            FileType rblFileType = FileTypeRegistry.getInstance().getFileTypeByExtension("rbl");
            if (rblFileType == UnknownFileType.INSTANCE) {
                rblFileType = null;
            }
            ourRblFileType = rblFileType;
        }
    }
}

