/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSStringConcatenationToES6TemplateHelper;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQuotedStringToTemplateStringIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSQuotedStringToTemplateStringIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSQuotedStringToTemplateStringIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        if (!ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        if (element.getContainingFile() instanceof JSFile || PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false) != null) {
            return JSQuotedStringToTemplateStringIntention.tryGetSingleLiteralExpression(element) != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSQuotedStringToTemplateStringIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSQuotedStringToTemplateStringIntention", "invoke"));
        }
        JSLiteralExpression jsLiteralExpression = JSQuotedStringToTemplateStringIntention.tryGetSingleLiteralExpression(element);
        if (jsLiteralExpression != null) {
            JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate(jsLiteralExpression);
        }
    }

    @Nullable
    private static JSLiteralExpression tryGetSingleLiteralExpression(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSQuotedStringToTemplateStringIntention", "tryGetSingleLiteralExpression"));
        }
        JSLiteralExpression literal = null;
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral()) {
            literal = (JSLiteralExpression)element;
        }
        if (element.getNode().getElementType() == JSTokenTypes.STRING_LITERAL && element.getParent() instanceof JSLiteralExpression) {
            literal = (JSLiteralExpression)element.getParent();
        }
        if (literal != null && !(literal.getParent() instanceof JSBinaryExpression)) {
            return literal;
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.replace.string.with.es6.template", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSQuotedStringToTemplateStringIntention", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.replace.string.with.es6.template.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSQuotedStringToTemplateStringIntention", "getFamilyName"));
        }
        return string;
    }
}

