/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterEditorNotificationPanel;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterEditorPanelCreator
extends AbstractProjectComponent {
    private final HashMap<Class, Key<JSLinterFileLevelAnnotation>> myKeys;
    private final FileEditorManager myEditorManager;

    public JSLinterEditorPanelCreator(Project project, @NotNull FileEditorManager editorManager) {
        if (editorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorManager", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator", "<init>"));
        }
        super(project);
        this.myKeys = new HashMap();
        this.myEditorManager = editorManager;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        MyFileEditorManagerListener handler = new MyFileEditorManagerListener();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)handler);
        connection.subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)handler);
    }

    @NotNull
    public String getComponentName() {
        if ("JSLinterEditorPanelCreator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator", "getComponentName"));
        }
        return "JSLinterEditorPanelCreator";
    }

    @NotNull
    public static JSLinterEditorPanelCreator getInstance(Project project) {
        JSLinterEditorPanelCreator jSLinterEditorPanelCreator = (JSLinterEditorPanelCreator)((Object)project.getComponent(JSLinterEditorPanelCreator.class));
        if (jSLinterEditorPanelCreator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator", "getInstance"));
        }
        return jSLinterEditorPanelCreator;
    }

    public void initComponent() {
        ExtensionPoint editorNotificationsEP = Extensions.getArea((AreaInstance)this.myProject).getExtensionPoint(EditorNotifications.EXTENSION_POINT_NAME);
        List jsAnnotators = Arrays.stream(ExternalLanguageAnnotators.EP_NAME.getExtensions()).map(extension -> (ExternalAnnotator)extension.getInstance()).filter(annotator -> annotator instanceof JSLinterWithInspectionExternalAnnotator).map(annotator -> (JSLinterWithInspectionExternalAnnotator)((Object)annotator)).collect(Collectors.toList());
        for (JSLinterWithInspectionExternalAnnotator annotator2 : jsAnnotators) {
            Class<JSLinterInspection> inspectionClass = annotator2.getInspectionClass();
            String uniqueIdentifier = inspectionClass.getClass().getSimpleName().replace("Inspection", "");
            MyJSLinterEditorNotificationPanel extension2 = new MyJSLinterEditorNotificationPanel(uniqueIdentifier, annotator2.getFileLevelAnnotationDefaultIcon(), inspectionClass);
            editorNotificationsEP.registerExtension((Object)extension2);
            this.myKeys.put(inspectionClass, extension2.getFileNotificationKey());
        }
    }

    public void projectClosed() {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.myEditorManager.getAllEditors()) {
            for (Key<JSLinterFileLevelAnnotation> key : this.myKeys.values()) {
                editor.putUserData(key, null);
            }
        }
    }

    public Key<JSLinterFileLevelAnnotation> getLinterNotificationsKey(@NotNull Class<? extends JSLinterInspection> inspectionClass) {
        if (inspectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionClass", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator", "getLinterNotificationsKey"));
        }
        return this.myKeys.get(inspectionClass);
    }

    private class MyFileEditorManagerListener
    extends FileEditorManagerAdapter
    implements FileEditorManagerListener.Before {
        private final MultiMap<VirtualFile, Pair<Key<JSLinterFileLevelAnnotation>, JSLinterFileLevelAnnotation>> myMap = new MultiMap();

        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            FileEditor[] editors;
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator$MyFileEditorManagerListener", "fileOpened"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator$MyFileEditorManagerListener", "fileOpened"));
            }
            Collection pairs = this.myMap.remove((Object)file);
            if (pairs == null) {
                return;
            }
            Map<Key, JSLinterFileLevelAnnotation> map = pairs.stream().collect(Collectors.toMap(pair -> (Key)pair.getFirst(), pair -> (JSLinterFileLevelAnnotation)pair.getSecond()));
            for (FileEditor editor : editors = source.getAllEditors(file)) {
                for (Key key : map.keySet()) {
                    JSLinterFileLevelAnnotation data = (JSLinterFileLevelAnnotation)editor.getUserData(key);
                    if (data != null) continue;
                    editor.putUserData(key, (Object)new JSLinterFileLevelAnnotation(map.get(key)));
                }
            }
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            FileEditor[] editors;
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator$MyFileEditorManagerListener", "fileClosed"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator$MyFileEditorManagerListener", "fileClosed"));
            }
            this.myMap.remove((Object)file);
            for (FileEditor editor : editors = source.getAllEditors(file)) {
                for (Key key : JSLinterEditorPanelCreator.this.myKeys.values()) {
                    editor.putUserData(key, null);
                }
            }
        }

        public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator$MyFileEditorManagerListener", "beforeFileOpened"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator$MyFileEditorManagerListener", "beforeFileOpened"));
            }
            FileEditor[] editors = source.getAllEditors(file);
            if (editors.length > 0) {
                FileEditor editor = editors[0];
                for (Key key : JSLinterEditorPanelCreator.this.myKeys.values()) {
                    JSLinterFileLevelAnnotation data = (JSLinterFileLevelAnnotation)editor.getUserData(key);
                    if (data == null) continue;
                    this.myMap.putValue((Object)file, (Object)Pair.create((Object)key, (Object)data));
                }
            }
        }

        public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator$MyFileEditorManagerListener", "beforeFileClosed"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator$MyFileEditorManagerListener", "beforeFileClosed"));
            }
        }
    }

    private static class MyJSLinterEditorNotificationPanel
    extends JSLinterEditorNotificationPanel {
        private final Key<EditorNotificationPanel> myNotificationPanelKey;
        private final Key<JSLinterFileLevelAnnotation> myKey;
        private Icon myIcon;

        public MyJSLinterEditorNotificationPanel(String uniqueIdentifier, Icon icon, Class<? extends JSLinterInspection> inspectionClass) {
            super(inspectionClass);
            this.myIcon = icon;
            this.myNotificationPanelKey = Key.create((String)("javascript.linter." + uniqueIdentifier + ".notification"));
            this.myKey = Key.create((String)("javascript.linter." + uniqueIdentifier + ".notification.panel"));
        }

        @Override
        protected Key<JSLinterFileLevelAnnotation> getFileNotificationKey() {
            return this.myKey;
        }

        @Override
        @Nullable
        protected Icon getIcon() {
            return this.myIcon;
        }

        @NotNull
        public Key<EditorNotificationPanel> getKey() {
            Key<EditorNotificationPanel> key = this.myNotificationPanelKey;
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterEditorPanelCreator$MyJSLinterEditorNotificationPanel", "getKey"));
            }
            return key;
        }
    }
}

