/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSLinterLanguageServicePackageTracker
implements StartupActivity {
    private static final Logger LOG = Logger.getInstance(JSLinterLanguageServicePackageTracker.class);

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterLanguageServicePackageTracker", "runActivity"));
        }
        List<Class<? extends JSLinterConfiguration>> linters = Arrays.stream(JSLinterDescriptor.EP_NAME.getExtensions()).filter(JSLinterDescriptor::usesLanguageService).map(JSLinterDescriptor::getConfigurationClass).collect(Collectors.toList());
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyListener(project, linters));
    }

    private static final class MyListener
    extends BulkVirtualFileListenerAdapter {
        public MyListener(final @NotNull Project project, final List<Class<? extends JSLinterConfiguration>> linterConfigurations) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterLanguageServicePackageTracker$MyListener", "<init>"));
            }
            super((VirtualFileListener)new VirtualFileContentsChangedAdapter(){

                protected void onFileChange(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterLanguageServicePackageTracker$MyListener$1", "onFileChange"));
                    }
                    if (("package.json".equals(file.getName()) || file.isDirectory()) && (JSLibraryUtil.getLibraryFolder(file, "node_modules") != null || "node_modules".equals(file.getName()))) {
                        Ref anyMatch = new Ref((Object)false);
                        linterConfigurations.forEach(configClass -> {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterLanguageServicePackageTracker$MyListener$1", "lambda$onFileChange$0"));
                            }
                            if (file == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterLanguageServicePackageTracker$MyListener$1", "lambda$onFileChange$0"));
                            }
                            Object instance = JSLinterConfiguration.getInstance(project, configClass);
                            if (!((JSLinterConfiguration)instance).isEnabled()) {
                                return;
                            }
                            JSNpmLinterState linterState = (JSNpmLinterState)ObjectUtils.tryCast(((JSLinterConfiguration)instance).getExtendedState().getState(), JSNpmLinterState.class);
                            if (linterState != null && !StringUtil.isEmptyOrSpaces((String)linterState.getLinterPackagePath()) && (!file.isDirectory() && FileUtil.pathsEqual((String)file.getParent().getPath(), (String)linterState.getLinterPackagePath()) || file.isDirectory() && FileUtil.isAncestor((String)file.getPath(), (String)linterState.getLinterPackagePath(), (boolean)false))) {
                                Class<JSLinterInspection> clazz = ((JSLinterConfiguration)instance).getInspectionClass();
                                LOG.debug(String.format("Restart '%s' service because of '%s' change", clazz.getName(), file.getPath()));
                                JSLinterInspection.ensureInspectionServiceStopped(project, clazz);
                                anyMatch.set((Object)true);
                            }
                        });
                        if (Boolean.TRUE.equals(anyMatch.get())) {
                            DaemonCodeAnalyzer.getInstance((Project)project).restart();
                        }
                    }
                }

                protected void onBeforeFileChange(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterLanguageServicePackageTracker$MyListener$1", "onBeforeFileChange"));
                    }
                }
            });
        }
    }
}

