/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.json.psi.JsonObject;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.LinterCodeStyleImportSourceTracker;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRulesImporter;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintImportCodeStyleEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"Eslint.Import.Code.Style.Notification");
    private static final Key<ParameterizedCachedValue<EslintRulesImporter, PsiFile>> CACHE_KEY = Key.create((String)"Eslint.Import.Code.Style.cache.key");
    private final LinterCodeStyleImportSourceTracker mySourceTracker;

    public EslintImportCodeStyleEditorNotificationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider", "<init>"));
        }
        this.mySourceTracker = new LinterCodeStyleImportSourceTracker(project, "eslint", (Processor<VirtualFile>)((Processor)file -> EslintUtil.isEslintConfigFile(file) || "package.json".equals(file.getName())));
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider", "createNotificationPanel"));
        }
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Project project = ((TextEditor)fileEditor).getEditor().getProject();
        if (project == null) {
            return null;
        }
        if (this.mySourceTracker.shouldDismiss(file)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)project);
        CodeStyleSettings settings = settingsManager.getCurrentSettings();
        CommonCodeStyleSettings common = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        JSCodeStyleSettings custom = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        if (common == null || custom == null) {
            return null;
        }
        EslintRulesImporter rulesImporter = (EslintRulesImporter)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)psiFile, CACHE_KEY, param -> {
            EslintRulesImporter importer = null;
            JsonObject rootObject = EslintUtil.getConfigRootObject(psiFile);
            if (rootObject != null) {
                importer = new EslintRulesImporter(rootObject);
            }
            return CachedValueProvider.Result.create((Object)importer, (Object[])new Object[]{psiFile});
        }, false, (Object)psiFile);
        if (rulesImporter != null && rulesImporter.hasDataToImport(common, custom)) {
            EditorNotificationPanel panel = new EditorNotificationPanel(EditorColors.GUTTER_BACKGROUND);
            panel.setText(JSBundle.message((String)"eslint.code.style.apply.message", (Object[])new Object[0]));
            panel.createActionLabel(JSBundle.message((String)"eslint.code.style.apply.text", (Object[])new Object[0]), () -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider", "lambda$createNotificationPanel$2"));
                }
                Set<String> importedRules = rulesImporter.doImport(project);
                EditorNotifications.getInstance((Project)project).updateNotifications(file);
                JSLinterUtil.reportCodeStyleSettingsImported(project, JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]), file, importedRules);
            });
            panel.createActionLabel(JSBundle.message((String)"eslint.code.style.dismiss.text", (Object[])new Object[0]), this.mySourceTracker.getDismissAction());
            return panel;
        }
        return null;
    }
}

