/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonUpdateNotifier;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeLocalDependenciesAction
extends AnAction
implements DumbAware {
    public InstallNodeLocalDependenciesAction() {
        super("Run 'npm install'", null, AllIcons.Actions.Install);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "update"));
        }
        Project project = e.getProject();
        VirtualFile packageJson = InstallNodeLocalDependenciesAction.getPackageJsonFile(e);
        boolean show = project != null && packageJson != null;
        e.getPresentation().setEnabledAndVisible(show);
        if (show) {
            NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getDefault();
            NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
            boolean yarn = localInterpreter != null && localInterpreter.isYarnAlikePackage();
            NpmCommand npmCommand = InstallNodeLocalDependenciesAction.guessNpmCommand(packageJson);
            String exe = yarn ? "yarn" : "npm";
            e.getPresentation().setText("Run '" + exe + " " + npmCommand.getCliOption(yarn) + "'");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "actionPerformed"));
        }
        Project project = e.getProject();
        VirtualFile packageJson = InstallNodeLocalDependenciesAction.getPackageJsonFile(e);
        if (project != null && packageJson != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
        }
    }

    @NotNull
    public static NpmCommand guessNpmCommand(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "guessNpmCommand"));
        }
        VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
        NpmCommand npmCommand = nodeModulesDir != null ? NpmCommand.UPDATE : NpmCommand.INSTALL;
        if (npmCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "guessNpmCommand"));
        }
        return npmCommand;
    }

    @Nullable
    private static VirtualFile getPackageJsonFile(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "getPackageJsonFile"));
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file != null && PackageJsonUtil.isPackageJsonFile(file) && file.isValid()) {
            return file;
        }
        return null;
    }

    public static void runAndShowConsole(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "runAndShowConsole"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "runAndShowConsole"));
        }
        InstallNodeLocalDependenciesAction.runAndShowConsole(project, Collections.singletonList(packageJson));
    }

    public static void runAndShowConsole(final @NotNull Project project, final @NotNull List<VirtualFile> packageJsonFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "runAndShowConsole"));
        }
        if (packageJsonFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "runAndShowConsole"));
        }
        final VirtualFile packageJson = (VirtualFile)ContainerUtil.getFirstItem(packageJsonFiles);
        if (packageJson == null) {
            return;
        }
        InstallNodeLocalDependenciesAction.saveFile(packageJson);
        final NpmCommand npmCommand = InstallNodeLocalDependenciesAction.guessNpmCommand(packageJson);
        ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(project, DefaultRunExecutor.getRunExecutorInstance()).runProfile(new RunProfile(){

            public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$1", "getState"));
                }
                if (environment == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$1", "getState"));
                }
                return new MyRunProfileState(environment.getProject(), packageJson, npmCommand, packageJsonFiles.subList(1, packageJsonFiles.size()));
            }

            public String getName() {
                String text = NpmCommand.INSTALL == npmCommand ? "Node.js dependencies installation" : "Node.js dependencies " + npmCommand.getCliOption();
                text = text + " for " + JsbtUtil.getRelativePath(project, packageJson);
                return text;
            }

            @Nullable
            public Icon getIcon() {
                return AllIcons.Actions.Install;
            }
        });
        ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
    }

    static void saveFile(@NotNull VirtualFile file) {
        Document doc;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "saveFile"));
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        if (fileDocumentManager.isFileModified(file) && (doc = fileDocumentManager.getDocument(file)) != null) {
            fileDocumentManager.saveDocument(doc);
        }
    }

    @NotNull
    private static NodeJsLocalInterpreter getProjectLocalInterpreter(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "getProjectLocalInterpreter"));
        }
        if (packageJsonFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "getProjectLocalInterpreter"));
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getDefault();
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            throw new NodeInterpreterException(project, packageJsonFiles, "No local Node.js interpreter");
        }
        if (!localInterpreter.isValid()) {
            throw new NodeInterpreterException(project, packageJsonFiles, "Invalid \"" + localInterpreter.getInterpreterSystemDependentPath() + "\"");
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
        if (nodeJsLocalInterpreter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "getProjectLocalInterpreter"));
        }
        return nodeJsLocalInterpreter;
    }

    private static class NodeInterpreterException
    extends ExecutionException
    implements HyperlinkListener {
        private final Project myProject;
        private final List<VirtualFile> myPackageJsonFiles;

        private NodeInterpreterException(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles, @NotNull String details) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$NodeInterpreterException", "<init>"));
            }
            if (packageJsonFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFiles", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$NodeInterpreterException", "<init>"));
            }
            if (details == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$NodeInterpreterException", "<init>"));
            }
            super(details + "<p/>Please specify local Node.js interpreter in <a href=''>Node.js and NPM</a>");
            this.myProject = project;
            this.myPackageJsonFiles = packageJsonFiles;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                NodeJSSettingsManager.editSettingsAppropriately(this.myProject);
                NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getDefault();
                try {
                    NodeJsLocalInterpreter.castAndValidate(interpreter);
                    InstallNodeLocalDependenciesAction.runAndShowConsole(this.myProject, this.myPackageJsonFiles);
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }
    }

    private static class MyRunProfileState
    implements RunProfileState {
        private final Project myProject;
        private final VirtualFile myPackageJson;
        private final NpmCommand myNpmCommand;
        private final List<VirtualFile> myEnqueuedPackageJsonFiles;

        public MyRunProfileState(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull NpmCommand npmCommand, @NotNull List<VirtualFile> enqueuedPackageJsonFiles) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "<init>"));
            }
            if (packageJson == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "<init>"));
            }
            if (npmCommand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmCommand", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "<init>"));
            }
            if (enqueuedPackageJsonFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enqueuedPackageJsonFiles", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "<init>"));
            }
            this.myProject = project;
            this.myPackageJson = packageJson;
            this.myNpmCommand = npmCommand;
            this.myEnqueuedPackageJsonFiles = enqueuedPackageJsonFiles;
        }

        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "execute"));
            }
            VirtualFile dir = this.myPackageJson.getParent();
            if (dir == null) {
                throw new ExecutionException("Cannot determine package.json directory");
            }
            TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
            consoleBuilder.addFilter((Filter)new NodeStackTraceFilter(this.myProject, dir));
            NodeJsLocalInterpreter localInterpreter = InstallNodeLocalDependenciesAction.getProjectLocalInterpreter(this.myProject, ContainerUtil.concat(Collections.singletonList(this.myPackageJson), this.myEnqueuedPackageJsonFiles));
            final Runnable doneCallback = PackageJsonDependenciesExternalUpdateManager.getInstance(this.myProject).externalUpdateStarted(null);
            PackageJsonUpdateNotifier.getInstance(this.myProject).scheduleProcessing(this.myPackageJson);
            GeneralCommandLine commandLine = MyRunProfileState.createCommandLine(this.myProject, dir, localInterpreter, this.myNpmCommand);
            KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine, true);
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            ConsoleView console = consoleBuilder.getConsole();
            console.attachToProcess((ProcessHandler)processHandler);
            ConsoleProgress.install(console, (ProcessHandler)processHandler);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    doneCallback.run();
                    PackageJsonUpdateNotifier.getInstance(myProject).scheduleProcessing(myPackageJson);
                    if (event.getExitCode() == 0) {
                        new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)myProject).addRequest(() -> InstallNodeLocalDependenciesAction.runAndShowConsole(myProject, myEnqueuedPackageJsonFiles), 2000);
                    }
                }
            });
            return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        }

        @NotNull
        private static GeneralCommandLine createCommandLine(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull NodeJsLocalInterpreter localInterpreter, @NotNull NpmCommand npmCommand) throws ExecutionException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "createCommandLine"));
            }
            if (workingDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "createCommandLine"));
            }
            if (localInterpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localInterpreter", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "createCommandLine"));
            }
            if (npmCommand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmCommand", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "createCommandLine"));
            }
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
            NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
            commandLine.setWorkDirectory(workingDir.getPath());
            commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
            commandLine.setExePath(localInterpreter.getInterpreterSystemDependentPath());
            String cliJsFilePath = localInterpreter.getValidNpmCliJsFilePath(project);
            commandLine.addParameter(cliJsFilePath);
            commandLine.addParameter(npmCommand.getCliOption(localInterpreter.isYarnAlikePackage()));
            if (!localInterpreter.isYarnAlikePackage()) {
                commandLine.addParameter("--scripts-prepend-node-path=auto");
            }
            GeneralCommandLine generalCommandLine = commandLine;
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "createCommandLine"));
            }
            return generalCommandLine;
        }
    }
}

