/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LastImportRequireInScope {
    private final boolean myPreferImport;
    private String myRequireName = "require";
    private boolean myNoticeRequire = true;

    public LastImportRequireInScope(boolean preferImport) {
        this.myPreferImport = preferImport;
    }

    public LastImportRequireInScope withRequireName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/LastImportRequireInScope", "withRequireName"));
        }
        this.myRequireName = name;
        return this;
    }

    public LastImportRequireInScope withNoticeRequire(boolean value) {
        this.myNoticeRequire = value;
        return this;
    }

    @Nullable
    public PsiElement findAndSelect(@NotNull PsiElement scopeElement) {
        PsiElement[] topChildren;
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/javascript/modules/LastImportRequireInScope", "findAndSelect"));
        }
        PsiElement lastRequireElement = null;
        PsiElement lastImportElement = null;
        for (PsiElement topChild : topChildren = scopeElement.getChildren()) {
            if (this.myNoticeRequire && topChild instanceof JSVarStatement) {
                JSVariable[] variables;
                for (JSVariable variable : variables = ((JSVarStatement)topChild).getVariables()) {
                    if (!this.isRequireExpression(variable.getInitializer())) continue;
                    lastRequireElement = topChild;
                }
            } else if (this.myNoticeRequire && topChild instanceof JSExpressionStatement) {
                if (this.isRequireExpression(((JSExpressionStatement)topChild).getExpression())) {
                    lastRequireElement = topChild;
                }
            } else if (topChild instanceof ES6ImportDeclaration) {
                lastImportElement = topChild;
            }
            if (lastImportElement != null && lastRequireElement != null) break;
        }
        return this.selectVariant(lastImportElement, lastRequireElement);
    }

    @Nullable
    private PsiElement selectVariant(@Nullable PsiElement lastImportElement, @Nullable PsiElement lastRequireElement) {
        if (this.myPreferImport) {
            return lastImportElement != null ? lastImportElement : lastRequireElement;
        }
        return lastRequireElement != null ? lastRequireElement : lastImportElement;
    }

    private boolean isRequireExpression(JSExpression initializer) {
        if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).getArguments().length == 1) {
            for (PsiElement element : initializer.getChildren()) {
                if (!(element instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)element, this.myRequireName)) continue;
                return true;
            }
        }
        return false;
    }
}

